/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.naming.InvalidNameException;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.ldap.LdapContext;
import org.apache.directory.server.core.interceptor.context.AddContextPartitionOperationContext;
import org.apache.directory.server.core.interceptor.context.CompareOperationContext;
import org.apache.directory.server.core.interceptor.context.GetMatchedNameOperationContext;
import org.apache.directory.server.core.interceptor.context.GetRootDSEOperationContext;
import org.apache.directory.server.core.interceptor.context.GetSuffixOperationContext;
import org.apache.directory.server.core.interceptor.context.ListSuffixOperationContext;
import org.apache.directory.server.core.interceptor.context.RemoveContextPartitionOperationContext;
import org.apache.directory.server.core.partition.Partition;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.schema.NoOpNormalizer;
import org.apache.directory.shared.ldap.schema.Normalizer;
import org.apache.directory.shared.ldap.schema.OidNormalizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PartitionNexus
implements Partition {
    public static final String ADMIN_PRINCIPAL = "uid=admin,ou=system";
    public static final String GLOBAL_SCHEMA_SUBENTRY_DN = "cn=schema";
    public static final String ADMIN_PRINCIPAL_NORMALIZED = "0.9.2342.19200300.100.1.1=admin,2.5.4.11=system";
    public static final String ADMIN_UID = "admin";
    public static final String ADMIN_PASSWORD = "secret";
    public static final String USERS_BASE_NAME = "ou=users,ou=system";
    public static final String GROUPS_BASE_NAME = "ou=groups,ou=system";
    public static final String SYSTEM_PARTITION_SUFFIX = "ou=system";

    public static final LdapDN getAdminName() {
        LdapDN adminDn = null;
        try {
            adminDn = new LdapDN(ADMIN_PRINCIPAL);
        }
        catch (NamingException e) {
            throw new InternalError();
        }
        try {
            HashMap<String, OidNormalizer> oidsMap = new HashMap<String, OidNormalizer>();
            oidsMap.put("uid", new OidNormalizer("0.9.2342.19200300.100.1.1", (Normalizer)new NoOpNormalizer()));
            oidsMap.put("userid", new OidNormalizer("0.9.2342.19200300.100.1.1", (Normalizer)new NoOpNormalizer()));
            oidsMap.put("0.9.2342.19200300.100.1.1", new OidNormalizer("0.9.2342.19200300.100.1.1", (Normalizer)new NoOpNormalizer()));
            oidsMap.put("ou", new OidNormalizer("2.5.4.11", (Normalizer)new NoOpNormalizer()));
            oidsMap.put("organizationalUnitName", new OidNormalizer("2.5.4.11", (Normalizer)new NoOpNormalizer()));
            oidsMap.put("2.5.4.11", new OidNormalizer("2.5.4.11", (Normalizer)new NoOpNormalizer()));
            adminDn.normalize(oidsMap);
        }
        catch (InvalidNameException ine) {
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        return adminDn;
    }

    public static final LdapDN getGroupsBaseName() {
        LdapDN groupsBaseDn = null;
        try {
            groupsBaseDn = new LdapDN(GROUPS_BASE_NAME);
        }
        catch (NamingException e) {
            throw new InternalError();
        }
        return groupsBaseDn;
    }

    public static final LdapDN getUsersBaseName() {
        LdapDN usersBaseDn = null;
        try {
            usersBaseDn = new LdapDN(USERS_BASE_NAME);
        }
        catch (NamingException e) {
            throw new InternalError();
        }
        return usersBaseDn;
    }

    public abstract LdapContext getLdapContext();

    public abstract Attributes getRootDSE(GetRootDSEOperationContext var1) throws NamingException;

    public abstract boolean compare(CompareOperationContext var1) throws NamingException;

    public abstract void addContextPartition(AddContextPartitionOperationContext var1) throws NamingException;

    public abstract void removeContextPartition(RemoveContextPartitionOperationContext var1) throws NamingException;

    public abstract Partition getSystemPartition();

    public abstract Partition getPartition(LdapDN var1) throws NamingException;

    public abstract LdapDN getMatchedName(GetMatchedNameOperationContext var1) throws NamingException;

    public abstract LdapDN getSuffix(GetSuffixOperationContext var1) throws NamingException;

    public abstract Iterator<String> listSuffixes(ListSuffixOperationContext var1) throws NamingException;

    public abstract void registerSupportedExtensions(Set<String> var1);
}

