/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import org.elasticsearch.Version;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.analysis.TokenizerFactory;
import org.elasticsearch.index.analysis.TokenizerFactoryFactory;
import org.elasticsearch.indices.analysis.PreBuiltTokenizers;

public class PreBuiltTokenizerFactoryFactory
implements TokenizerFactoryFactory {
    private final TokenizerFactory tokenizerFactory;

    public PreBuiltTokenizerFactoryFactory(TokenizerFactory tokenizerFactory) {
        this.tokenizerFactory = tokenizerFactory;
    }

    @Override
    public TokenizerFactory create(String name, Settings settings) {
        PreBuiltTokenizers preBuiltTokenizers;
        Version indexVersion = settings.getAsVersion("index.version.created", Version.CURRENT);
        if (!Version.CURRENT.equals(indexVersion) && (preBuiltTokenizers = PreBuiltTokenizers.getOrDefault(name, null)) != null) {
            return preBuiltTokenizers.getTokenizerFactory(indexVersion);
        }
        return this.tokenizerFactory;
    }
}

