/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.operation;

import fr.toutatice.ecm.platform.core.helper.ToutaticeDocumentHelper;
import fr.toutatice.ecm.platform.core.helper.ToutaticeFilter;
import fr.toutatice.ecm.platform.core.helper.ToutaticeOperationHelper;
import fr.toutatice.ecm.platform.core.helper.ToutaticeSilentProcessRunnerHelper;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.runtime.api.Framework;

@Operation(id="Document.SetACLsDependingTargetAudience", category="Document", label="Change the ACLs in the target audience ", description="change the ACLs in the target audience. Si pas de public cible les ACLS sont h\u00e9rit\u00e9s. ")
public class SetACLsDependingTargetAudience {
    public static final String ID = "Document.SetACLsDependingTargetAudience";
    private static final String ACE_FORMAT = "%s:%s:%s";
    private static final Log log = LogFactory.getLog(SetACLsDependingTargetAudience.class);
    @Param(name="targetsXpath", required=false)
    protected String xpath;
    @Param(name="isDirect", required=true)
    protected boolean isDirect;
    @Param(name="aclName", required=false)
    protected String aclName;
    @Context
    protected CoreSession session;

    @OperationMethod
    public DocumentModel run(DocumentModel doc) throws Exception {
        InnerSilentSetACLsDependingTargetAudience runner = new InnerSilentSetACLsDependingTargetAudience(this.session, doc);
        runner.silentRun(true);
        return doc;
    }

    private class InnerSilentSetACLsDependingTargetAudience
    extends ToutaticeSilentProcessRunnerHelper {
        private DocumentModel doc;

        public InnerSilentSetACLsDependingTargetAudience(CoreSession session, DocumentModel doc) {
            super(session);
            this.doc = doc;
        }

        public void run() throws ClientException {
            String[] tabCibles;
            DocumentRef docRef = this.doc.getRef();
            if (StringUtils.isBlank((String)SetACLsDependingTargetAudience.this.xpath)) {
                SetACLsDependingTargetAudience.this.xpath = "cld:publicCible";
            }
            if ((tabCibles = (String[])this.doc.getPropertyValue(SetACLsDependingTargetAudience.this.xpath)) == null || tabCibles.length == 0) {
                ACP acp = this.doc.getACP();
                acp.removeACL("local");
                this.session.setACP(docRef, acp, true);
            } else {
                ToutaticeFilter<ACE> filter = new ToutaticeFilter<ACE>(){

                    public boolean accept(ACE t) {
                        return t.isGranted() && !"Read".equals(t.getPermission());
                    }
                };
                ACL acl = null;
                if (SetACLsDependingTargetAudience.this.aclName == null) {
                    SetACLsDependingTargetAudience.this.aclName = "*";
                }
                if (SetACLsDependingTargetAudience.this.isDirect) {
                    acl = ToutaticeDocumentHelper.getDocumentACL((CoreSession)this.session, (DocumentModel)this.doc, (String)SetACLsDependingTargetAudience.this.aclName, (ToutaticeFilter)filter);
                } else {
                    DocumentModel docParent = this.session.getParentDocument(this.doc.getRef());
                    acl = ToutaticeDocumentHelper.getDocumentACL((CoreSession)this.session, (DocumentModel)docParent, (String)SetACLsDependingTargetAudience.this.aclName, (ToutaticeFilter)filter);
                }
                ArrayList<String> entries = new ArrayList<String>(tabCibles.length);
                for (ACE ace : acl) {
                    entries.add(String.format(SetACLsDependingTargetAudience.ACE_FORMAT, ace.getUsername(), ace.getPermission(), true));
                }
                for (String cible : tabCibles) {
                    entries.add(String.format(SetACLsDependingTargetAudience.ACE_FORMAT, cible, "Read", true));
                }
                AutomationService automation = null;
                try {
                    automation = (AutomationService)Framework.getService(AutomationService.class);
                }
                catch (Exception e) {
                    log.warn((Object)("Error getting automation service, error: " + e.getMessage()));
                    throw new ClientException((Throwable)e);
                }
                OperationContext ctx = new OperationContext(this.session);
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                parameters.put("entries", StringUtils.join(entries, (char)','));
                parameters.put("overwrite", true);
                parameters.put("break", true);
                parameters.put("acl", "local");
                ctx.setInput((Object)this.doc);
                try {
                    this.doc = (DocumentModel)ToutaticeOperationHelper.callOperation((OperationContext)ctx, (String)"Document.SetACL", parameters);
                }
                catch (Exception e) {
                    throw new ClientException((Throwable)e);
                }
            }
        }
    }
}

