/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.target;

import fr.toutatice.ecm.platform.constants.PPFConstants;
import fr.toutatice.ecm.platform.core.helper.ToutaticeDocumentHelper;
import fr.toutatice.ecm.platform.target.TargetPublicBean;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.faces.FacesMessages;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.Filter;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.PropertyException;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.util.ComponentUtils;
import org.nuxeo.ecm.webapp.base.InputController;

@Name(value="targetPublicActions")
@Scope(value=ScopeType.PAGE)
@Install(precedence=30)
public class TargetPublicActionsBean
extends InputController
implements TargetPublicBean,
Serializable,
PPFConstants {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(TargetPublicActionsBean.class);
    @In(create=true)
    protected transient NavigationContext navigationContext;
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    protected List<String> groupName;
    protected String label;
    protected Integer order;
    protected Target modifyTarget;
    protected List<HashMap<String, Object>> lstTarget;
    private Map<String, String> lstItemsSelectable = null;
    private Map<String, String> lstItemsChosen = null;
    private Map<String, String> targetsDocument = null;
    private Boolean isDefaultValue = null;
    private List<String> lstValuesChosen = new ArrayList<String>();

    @Override
    public void addTargetPublicAuth() throws ClientException {
        DocumentModel doc = this.navigationContext.getCurrentDocument();
        if (this.groupName == null || this.groupName.isEmpty()) {
            String message = ComponentUtils.translate((FacesContext)FacesContext.getCurrentInstance(), (String)"ppf.error.group.null");
            FacesMessages.instance().add(message, new Object[0]);
        } else {
            try {
                List lst = (List)((Object)doc.getPropertyValue("toutatice_space:lstPublicAuth"));
                boolean ismissing = true;
                if (lst != null && !lst.isEmpty()) {
                    for (HashMap data : lst) {
                        String id = (String)data.get("pcid");
                        if (!this.groupName.get(0).equals(id)) continue;
                        ismissing = false;
                        break;
                    }
                }
                if (ismissing) {
                    HashMap<String, Object> data = new HashMap<String, Object>();
                    data.put("pcid", this.groupName.get(0));
                    if (this.label == null) {
                        this.label = this.groupName.get(0);
                    }
                    data.put("pclabel", this.label);
                    if (this.order == null) {
                        data.put("pcorder", 999);
                    } else {
                        data.put("pcorder", this.order);
                    }
                    lst.add(data);
                    doc.setPropertyValue("toutatice_space:lstPublicAuth", (Serializable)lst.toArray(new Object[lst.size()]));
                    this.documentManager.saveDocument(doc);
                } else {
                    String message = ComponentUtils.translate((FacesContext)FacesContext.getCurrentInstance(), (String)"ppf.error.group.already.exist");
                    FacesMessages.instance().add(message, new Object[0]);
                }
            }
            catch (PropertyException e) {
                log.error((Object)(" *** " + e.getMessage()));
            }
            this.groupName.clear();
            this.label = null;
            this.order = null;
        }
    }

    @Override
    public void removeTargetPublicAuth(String groupid) throws ClientException {
        DocumentModel doc = this.navigationContext.getCurrentDocument();
        List lst = (List)((Object)doc.getPropertyValue("toutatice_space:lstPublicAuth"));
        if (lst != null && !lst.isEmpty()) {
            HashMap dataToRemove = null;
            for (HashMap data : lst) {
                String id = (String)data.get("pcid");
                if (!groupid.equals(id)) continue;
                dataToRemove = data;
                break;
            }
            if (dataToRemove != null) {
                lst.remove(dataToRemove);
                doc.setPropertyValue("toutatice_space:lstPublicAuth", (Serializable)lst.toArray(new Object[lst.size()]));
                this.documentManager.saveDocument(doc);
            } else {
                new ClientException("Le groupe \u00e0 supprimer n'a pas \u00e9t\u00e9 trouv\u00e9 dans la liste ");
            }
        }
    }

    @Override
    public void modifyTarget(String groupid) {
        this.modifyTarget = null;
        if (this.lstTarget != null && !this.lstTarget.isEmpty()) {
            for (HashMap<String, Object> data : this.lstTarget) {
                String id = (String)data.get("pcid");
                if (!groupid.equals(id)) continue;
                this.modifyTarget = new Target(groupid, (String)data.get("pclabel"));
                this.modifyTarget.setPcorder((Long)data.get("pcorder"));
                break;
            }
        }
    }

    @Override
    public List<HashMap<String, Object>> getLstPublishAuth() throws ClientException {
        DocumentModel psDoc = this.navigationContext.getCurrentDocument();
        List lst = null;
        ArrayList<String> lstXpaths = new ArrayList<String>(1);
        lstXpaths.add("toutatice_space:lstPublicAuth");
        Filter filter = new Filter(){
            private static final long serialVersionUID = 1L;

            public boolean accept(DocumentModel docFilter) {
                boolean status = false;
                try {
                    status = ToutaticeDocumentHelper.isAPublicationSpaceDocument((DocumentModel)docFilter);
                }
                catch (Exception e) {
                    log.error((Object)("Failed to filter the publish space documents, error: " + e.getMessage()));
                    status = false;
                }
                return status;
            }
        };
        Map mapPpty = ToutaticeDocumentHelper.getPropertiesParentDoc((CoreSession)this.documentManager, (DocumentModel)psDoc, lstXpaths, (Filter)filter, (boolean)true, (boolean)true);
        if (mapPpty != null) {
            lst = (List)((Object)((Property)mapPpty.get("toutatice_space:lstPublicAuth")).getValue());
            Collections.sort(lst, new PublicTargetComparator());
        }
        this.lstTarget = lst;
        return lst;
    }

    public Target getModifyTarget() {
        return this.modifyTarget;
    }

    public void setModifyTarget(Target modifyTarget) {
        this.modifyTarget = modifyTarget;
    }

    @Override
    public List<String> getGroupName() {
        return this.groupName;
    }

    @Override
    public void setGroupName(List<String> selectedEntry) {
        this.groupName = selectedEntry;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public Integer getOrder() {
        return this.order;
    }

    @Override
    public void setOrder(Integer order) {
        this.order = order;
    }

    @Override
    public void cancelModify() {
        this.modifyTarget = null;
    }

    @Override
    public void validateModify() {
        DocumentModel psDoc = this.navigationContext.getCurrentDocument();
        if (this.lstTarget != null && !this.lstTarget.isEmpty()) {
            Boolean b = false;
            for (HashMap<String, Object> data : this.lstTarget) {
                String id = (String)data.get("pcid");
                if (!this.modifyTarget.getPcid().equals(id)) continue;
                data.put("pclabel", this.modifyTarget.getPclabel());
                data.put("pcorder", this.modifyTarget.getPcorder());
                b = true;
                break;
            }
            if (b.booleanValue()) {
                psDoc.setPropertyValue("toutatice_space:lstPublicAuth", (Serializable)this.lstTarget.toArray(new Object[this.lstTarget.size()]));
                this.documentManager.saveDocument(psDoc);
            }
        }
    }

    public Map<String, String> getTargetsDocument() throws ClientException {
        List<HashMap<String, Object>> lstMap;
        if ((this.targetsDocument == null || this.targetsDocument.isEmpty()) && (lstMap = this.getLstPublishAuth()) != null) {
            this.targetsDocument = new LinkedHashMap<String, String>(lstMap.size());
            for (HashMap<String, Object> map : lstMap) {
                this.targetsDocument.put((String)map.get("pcid"), (String)map.get("pclabel"));
            }
        }
        return this.targetsDocument;
    }

    public Map<String, String> getLstItemsSelectable() throws ClientException {
        if (this.lstItemsSelectable == null && this.getTargetsDocument() != null) {
            this.initListsItems();
        }
        return this.lstItemsSelectable;
    }

    public Map<String, String> getLstItemsChosen() throws ClientException {
        if (this.lstItemsChosen == null && this.getTargetsDocument() != null) {
            this.initListsItems();
        }
        return this.lstItemsChosen;
    }

    public List<String> getKeysChosen() throws ClientException {
        if (this.lstItemsChosen == null) {
            this.getLstItemsChosen();
        }
        return new ArrayList<String>(this.lstItemsChosen.keySet());
    }

    public List<String> getLstValuesChosen() {
        return this.lstValuesChosen;
    }

    public void setLstValuesChosen(List<String> lstValuesChosen) throws ClientException {
        this.lstValuesChosen = lstValuesChosen;
        this.updatePropertyDocument();
    }

    private void initListsItems() {
        DocumentModel doc = this.navigationContext.getCurrentDocument();
        this.lstItemsChosen = new LinkedHashMap<String, String>();
        this.lstItemsSelectable = new LinkedHashMap<String, String>();
        Property ppt = doc.getProperty("ttc:lstTargetedPublic");
        List tabCibles = (List)ppt.convertTo(ppt.getValue(), List.class);
        for (String item : this.getTargetsDocument().keySet()) {
            if (tabCibles.contains(item)) {
                this.lstItemsChosen.put(this.targetsDocument.get(item), item);
                this.lstValuesChosen.add(item);
                continue;
            }
            this.lstItemsSelectable.put(this.targetsDocument.get(item), item);
        }
    }

    private void updatePropertyDocument() throws PropertyException, ClientException {
        DocumentModel doc = this.navigationContext.getChangeableDocument();
        if (doc == null) {
            doc = this.navigationContext.getCurrentDocument();
        }
        String[] tab = this.lstValuesChosen.toArray(new String[this.lstValuesChosen.size()]);
        doc.setProperty("toutatice", "lstTargetedPublic", (Object)tab);
    }

    public class Target {
        String pcid;
        String pclabel;
        Long pcorder;

        public Target(String id, String label) {
            this.pcid = id;
            this.pclabel = label;
        }

        public String getPcid() {
            return this.pcid;
        }

        public void setPcid(String pcid) {
            this.pcid = pcid;
        }

        public String getPclabel() {
            return this.pclabel;
        }

        public void setPclabel(String pclabel) {
            this.pclabel = pclabel;
        }

        public Long getPcorder() {
            return this.pcorder;
        }

        public void setPcorder(Long order) {
            this.pcorder = order;
        }
    }

    protected class PublicTargetComparator
    implements Comparator<HashMap<String, Object>> {
        List<HashMap<String, Object>> list;

        protected PublicTargetComparator() {
        }

        @Override
        public int compare(HashMap<String, Object> arg0, HashMap<String, Object> arg1) {
            Long order1;
            int res = 0;
            Long order0 = (Long)arg0.get("pcorder");
            res = order0.compareTo(order1 = (Long)arg1.get("pcorder"));
            if (res == 0) {
                String label0 = (String)arg0.get("pclabel");
                String label1 = (String)arg1.get("pclabel");
                res = label0.compareTo(label1);
            }
            return res;
        }
    }
}

