/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.routing.core.api.operation;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.platform.routing.api.DocumentRoute;
import org.nuxeo.ecm.platform.routing.core.api.DocumentRoutingEngineService;

@Operation(id="Context.CancelWorkflow", category="Workflow Context", label="Cancel workflow", requires="Workflow", description="Cancel the workflow with the given id, where the required id is the id of the document representing the workflow instance.")
public class CancelWorkflowOperation {
    public static final String ID = "Context.CancelWorkflow";
    private static final Log log = LogFactory.getLog(CancelWorkflowOperation.class);
    @Context
    protected CoreSession session;
    @Param(name="id")
    protected String id;
    @Context
    protected DocumentRoutingEngineService documentRoutingEngineService;

    @OperationMethod
    public void cancelWorkflow() throws ClientException {
        DocumentModel workflowInstance;
        try {
            workflowInstance = this.session.getDocument((DocumentRef)new IdRef(this.id));
        }
        catch (ClientException e) {
            log.error((Object)("Can not get workflow instance with id" + this.id));
            throw new ClientException(e);
        }
        this.documentRoutingEngineService.cancel((DocumentRoute)workflowInstance.getAdapter(DocumentRoute.class), this.session);
    }
}

