/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.routing.core.api.operation;

import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.platform.routing.api.DocumentRoutingService;

@Operation(id="Workflow.ResumeNodeOperation", category="Workflow Context", label="Resume workflow", requires="Workflow", description="Resumes a route instance on a given node. When a parameter is not specified, it will be fetched from the current context if the operation is executed in the context of a running workflow (it applies to the current workflow and to the current node).")
public class ResumeNodeOperation {
    public static final String ID = "Workflow.ResumeNodeOperation";
    @Context
    protected CoreSession session;
    @Context
    protected OperationContext ctx;
    @Param(name="workflowInstanceId", required=false)
    protected String workflowInstanceId;
    @Param(name="nodeId", required=false)
    protected String nodeId;
    @Context
    protected DocumentRoutingService documentRoutingService;

    @OperationMethod
    public void resumeWorkflow() throws ClientException {
        if (this.workflowInstanceId == null) {
            this.workflowInstanceId = (String)this.ctx.get((Object)"workflowInstanceId");
        }
        if (this.nodeId == null) {
            this.nodeId = (String)this.ctx.get((Object)"nodeId");
        }
        if (this.workflowInstanceId == null) {
            throw new ClientException("Can not resume workflow instance with id " + this.workflowInstanceId + ". No current instance in the context");
        }
        this.documentRoutingService.resumeInstance(this.workflowInstanceId, this.nodeId, null, null, this.session);
    }
}

