/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.query.nxql;

import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.Filter;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;

public class CoreQueryUnrestrictedSessionRunner
extends UnrestrictedSessionRunner {
    protected final String query;
    protected final Filter filter;
    protected final long limit;
    protected final long offset;
    protected final boolean countTotal;
    protected final long countUpTo;
    protected final boolean detachDocuments;
    protected DocumentModelList docs;

    public CoreQueryUnrestrictedSessionRunner(CoreSession session, String query, Filter filter, long limit, long offset, boolean countTotal, long countUpTo, boolean detachDocuments) {
        super(session);
        this.query = query;
        this.filter = filter;
        this.limit = limit;
        this.offset = offset;
        this.countTotal = countTotal;
        this.countUpTo = countUpTo;
        this.detachDocuments = detachDocuments;
    }

    public void run() throws ClientException {
        this.docs = this.countTotal ? this.session.query(this.query, this.filter, this.limit, this.offset, this.countTotal) : this.session.query(this.query, this.filter, this.limit, this.offset, this.countUpTo);
        if (this.docs != null && this.detachDocuments) {
            for (DocumentModel doc : this.docs) {
                doc.detach(true);
            }
        }
    }

    public DocumentModelList getDocs() {
        return this.docs;
    }
}

