/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.acrennes.builder;

import fr.toutatice.ecm.acrennes.builder.PublishableDocumentFinder;
import fr.toutatice.ecm.acrennes.builder.UserRootSectionsFinder;
import fr.toutatice.ecm.acrennes.model.PublishableDocument;
import fr.toutatice.ecm.acrennes.model.UserRootSection;
import fr.toutatice.ecm.acrennes.model.UserRootSectionByMaster;
import fr.toutatice.ecm.acrennes.model.UserRootSections;
import fr.toutatice.ecm.platform.core.helper.ToutaticeDocumentHelper;
import fr.toutatice.ecm.platform.core.publish.PublishedDocumentsFinder;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.platform.publisher.api.PublishedDocument;
import org.nuxeo.ecm.platform.publisher.impl.core.SimpleCorePublishedDocument;

public class UserRootSectionsBuilder {
    private static final Log log = LogFactory.getLog(UserRootSectionsBuilder.class);
    private UserRootSectionsFinder sectionsFinder;
    private PublishedDocumentsFinder publishedDocsFinder;
    private PublishableDocumentFinder publishableDocFinder;
    private CoreSession userSession;
    public static final String[] MASTER_ROOT_TYPES = new String[]{"Root", "SectionRoot"};

    public UserRootSectionsBuilder(CoreSession session) {
        this.userSession = session;
        this.sectionsFinder = new UserRootSectionsFinder(session);
        this.publishedDocsFinder = PublishedDocumentsFinder.getInstance();
        this.publishableDocFinder = PublishableDocumentFinder.getInstance();
    }

    public UserRootSections buildSectionsModel(DocumentModel document) {
        long b = System.currentTimeMillis();
        UserRootSections userSections = new UserRootSections();
        DocumentModelList sections = this.sectionsFinder.getConfiguredUserRootSections(this.userSession, document);
        if (CollectionUtils.isNotEmpty((Collection)sections)) {
            Map publishedDocsIn = this.publishedDocsFinder.find(this.userSession, document);
            DocumentModel publishableDocModel = this.publishableDocFinder.getPublishableDocument(this.userSession, document);
            PublishableDocument publishableDoc = new PublishableDocument(publishableDocModel);
            for (DocumentModel section : sections) {
                UserRootSection userSection = new UserRootSection(section);
                PublishedDocument publishedDocument = (PublishedDocument)publishedDocsIn.get(section.getRef());
                userSection.setPublishedDoc(publishedDocument);
                boolean canPublish = this.setCanPublishTo(publishedDocument, publishableDoc, section, document);
                userSection.setCanPublishTo(canPublish);
                userSections.setPublishableDoc(publishableDoc);
                boolean canUnPublish = this.setCanUnpublishFrom(publishedDocument, section);
                userSection.setCanUnPublishFrom(canUnPublish);
                DocumentModel matserRoot = this.sectionsFinder.getMatserRoot(this.userSession, section, document);
                UserRootSectionByMaster userSectionMaster = new UserRootSectionByMaster(matserRoot, userSection);
                userSections.add(userSectionMaster);
            }
        }
        if (log.isDebugEnabled()) {
            long e = System.currentTimeMillis();
            log.debug((Object)("#buildModel: " + String.valueOf(e - b) + " ms"));
        }
        return userSections;
    }

    private boolean setCanPublishTo(PublishedDocument publishedDocument, PublishableDocument publishableDoc, DocumentModel section, DocumentModel document) {
        boolean can;
        boolean bl = can = publishableDoc.getModel() != null;
        if (can) {
            can = !ArrayUtils.contains((Object[])MASTER_ROOT_TYPES, (Object)section.getType());
            can &= this.userSession.getLockInfo(document.getRef()) == null;
            boolean userHasPerm = this.userSession.hasPermission(section.getRef(), "CanAskForPublishing");
            if (!userHasPerm) {
                publishableDoc.setError(section, PublishableDocument.Error.noPerm);
            }
            if (can &= userHasPerm) {
                boolean bl2 = can = publishedDocument == null;
                if (!can) {
                    DocumentModel yetPublishedDoc = this.userSession.getDocument(publishedDocument.getSourceDocumentRef());
                    can = ToutaticeDocumentHelper.DocumentVersionComparator.isNewer((DocumentModel)yetPublishedDoc, (DocumentModel)publishableDoc.getModel());
                }
            }
        } else {
            publishableDoc.setError(section, PublishableDocument.Error.notExists);
        }
        return can;
    }

    private boolean setCanUnpublishFrom(PublishedDocument publishedDocument, DocumentModel section) {
        boolean can = publishedDocument != null && publishedDocument instanceof SimpleCorePublishedDocument;
        return can && this.userSession.hasPermission(section.getRef(), "Write");
    }
}

