/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.acrennes.model;

import java.util.HashMap;
import java.util.Map;
import org.nuxeo.ecm.core.api.DocumentModel;

public class PublishableDocument {
    private DocumentModel model;
    private String versionLabel;
    private Map<DocumentModel, Error> errors;

    public PublishableDocument(DocumentModel model) {
        this.model = model;
        this.errors = new HashMap<DocumentModel, Error>();
    }

    public DocumentModel getModel() {
        return this.model;
    }

    public void setModel(DocumentModel model) {
        this.model = model;
    }

    public Map<DocumentModel, Error> getErrors() {
        return this.errors;
    }

    public void setErrors(Map<DocumentModel, Error> errors) {
        this.errors = errors;
    }

    public String getVersionLabel() {
        return this.versionLabel;
    }

    public void setVersionLabel(String versionLabel) {
        this.versionLabel = versionLabel;
    }

    public boolean hasError(DocumentModel section) {
        return this.errors.get(section) != null;
    }

    public Error getError(DocumentModel section) {
        return this.errors.get(section);
    }

    public void setError(DocumentModel section, Error error) {
        this.errors.put(section, error);
    }

    public static enum Error {
        notExists("toutatice.label.publish.not.available"),
        noPerm("toutatice.label.publish.no.permission");

        private String messageKey;

        private Error(String messageKey) {
            this.messageKey = messageKey;
        }

        public String getMessageKey() {
            return this.messageKey;
        }

        public void setMessageKey(String messageKey) {
            this.messageKey = messageKey;
        }
    }
}

