/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.acrennes.ui;

import fr.toutatice.ecm.acrennes.publishing.AcrennesPublishedDocumentWithWorkflowFactory;
import fr.toutatice.ecm.acrennes.ui.AcrennesUserRootSectionsManager;
import java.io.Serializable;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.core.Events;
import org.jboss.seam.faces.FacesMessages;
import org.jboss.seam.international.StatusMessage;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.publisher.api.PublishedDocument;
import org.nuxeo.ecm.platform.publisher.api.PublishingEvent;
import org.nuxeo.ecm.platform.publisher.web.PublishActionsBean;
import org.nuxeo.ecm.platform.ui.web.util.ComponentUtils;
import org.nuxeo.ecm.platform.ui.web.util.SeamComponentCallHelper;

@Name(value="acrennesPublishingActions")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=32)
public class AcrennesPublishingActions
implements Serializable {
    private static final long serialVersionUID = -4158103274671992562L;
    private static final Log log = LogFactory.getLog(AcrennesPublishingActions.class);
    @In(create=true)
    protected transient CoreSession documentManager;
    @In(create=true, required=false)
    protected transient FacesMessages facesMessages;
    @In(create=true)
    protected Map<String, String> messages;
    protected transient AcrennesPublishedDocumentWithWorkflowFactory factory;

    @Create
    public void init() {
        if (this.factory == null) {
            this.factory = AcrennesPublishedDocumentWithWorkflowFactory.getInstance();
        }
    }

    public String publish(DocumentModel publishableDoc, DocumentModel section) {
        PublishedDocument publishedDocument = this.factory.publish(this.documentManager, publishableDoc, section);
        this.resetModel();
        this.notify(publishedDocument, section, publishableDoc);
        return null;
    }

    public String unPublish(PublishedDocument publishedDoc) throws InterruptedException {
        this.factory.unPublish(this.documentManager, publishedDoc);
        this.resetModel();
        Events.instance().raiseEvent("documentChildrenChanged", new Object[0]);
        return null;
    }

    protected void resetModel() {
        AcrennesUserRootSectionsManager sectionsManager = (AcrennesUserRootSectionsManager)SeamComponentCallHelper.getSeamComponentByName((String)"sectionsManager");
        sectionsManager.setSections(null);
    }

    public void notify(PublishedDocument publishedDocument, DocumentModel section, DocumentModel publishableDoc) {
        String comment;
        long b = System.currentTimeMillis();
        FacesContext context = FacesContext.getCurrentInstance();
        if (publishedDocument.isPending()) {
            comment = ComponentUtils.translate((FacesContext)context, (String)"publishing.waiting", (Object[])new Object[]{section.getPath()});
            Events.instance().raiseEvent("documentSubmitedForPublication", new Object[0]);
            PublishActionsBean.notifyEvent((CoreSession)this.documentManager, (String)PublishingEvent.documentWaitingPublication.name(), null, (String)comment, null, (DocumentModel)publishableDoc);
            this.facesMessages.addFromResourceBundle(StatusMessage.Severity.INFO, this.messages.get("document_submitted_for_publication"), new Object[]{this.messages.get(publishableDoc.getType())});
        } else {
            comment = ComponentUtils.translate((FacesContext)context, (String)"publishing.done", (Object[])new Object[]{section.getPath()});
            Events.instance().raiseEvent("documentPublished", new Object[0]);
            PublishActionsBean.notifyEvent((CoreSession)this.documentManager, (String)PublishingEvent.documentPublished.name(), null, (String)comment, null, (DocumentModel)publishableDoc);
            this.facesMessages.addFromResourceBundle(StatusMessage.Severity.INFO, this.messages.get("document_published"), new Object[]{this.messages.get(publishableDoc.getType())});
        }
        if (log.isDebugEnabled()) {
            long e = System.currentTimeMillis();
            log.debug((Object)("#notify : " + String.valueOf(e - b) + " ms"));
        }
    }
}

