/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.web.publication.validation;

import fr.toutatice.ecm.acrennes.builder.UserRootSectionsFinder;
import fr.toutatice.ecm.acrennes.ui.AcrennesUserRootSectionsManager;
import fr.toutatice.ecm.platform.core.constants.ToutaticeGlobalConst;
import fr.toutatice.ecm.platform.core.helper.ToutaticeDocumentHelper;
import fr.toutatice.ecm.platform.core.helper.ToutaticeNotifyEventHelper;
import fr.toutatice.ecm.platform.web.context.ToutaticeNavigationContext;
import fr.toutatice.ecm.platform.web.document.ToutaticeDocumentActions;
import fr.toutatice.ecm.platform.web.publication.ToutaticeAdministrationPublishActions;
import fr.toutatice.ecm.platform.web.publication.finder.ToutaticeRemoteRootSectionsFinder;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.faces.FacesMessages;
import org.jboss.seam.international.StatusMessage;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.Filter;
import org.nuxeo.ecm.core.api.Sorter;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.platform.ui.web.util.SeamComponentCallHelper;
import org.nuxeo.ecm.webapp.contentbrowser.DocumentActions;
import org.nuxeo.ecm.webapp.helpers.ResourcesAccessor;
import org.nuxeo.ecm.webapp.tree.DocumentTreeNode;
import org.nuxeo.ecm.webapp.tree.DocumentTreeNodeImpl;

@Name(value="adminPublishActions")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=32)
public class ToutaticeAdministrationRemotePublishActions
extends ToutaticeAdministrationPublishActions
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(ToutaticeAdministrationRemotePublishActions.class);
    private static final String[] ACCEPTED_LIFE_CYCLE_STATES = new String[]{"project", "approved"};
    @In(create=true)
    protected transient FacesMessages facesMessages;
    @In(create=true)
    protected transient ResourcesAccessor resourcesAccessor;
    @In(create=true)
    protected DocumentActions documentActions;

    public String addSection(String sectionId) throws ClientException {
        String res = super.addSection(sectionId);
        this.resetUserRootSectionsModel();
        return res;
    }

    public String removeSection(String sectionId) throws ClientException {
        String res = super.removeSection(sectionId);
        this.resetUserRootSectionsModel();
        return res;
    }

    @Observer(value={"sectionModified"})
    public void resetUserRootSectionsModelOnEvent() {
        this.resetUserRootSectionsModel();
    }

    protected void resetUserRootSectionsModel() {
        UserRootSectionsFinder.invalidateSectionsCache(this.navigationContext.getCurrentDocument());
        AcrennesUserRootSectionsManager sectionsManager = (AcrennesUserRootSectionsManager)SeamComponentCallHelper.getSeamComponentByName((String)"sectionsManager");
        sectionsManager.setSections(null);
    }

    public boolean canAddSection(DocumentModel section) throws ClientException {
        boolean status = false;
        if (section != null && !section.hasFacet("MasterPublishSpace")) {
            status = super.canAddSection(section);
        }
        return status;
    }

    protected DocumentTreeNode getDocumentTreeNode(DocumentModel document) {
        DocumentTreeNodeImpl dtn = null;
        if (document != null) {
            Filter filter = null;
            Sorter sorter = null;
            String pageProviderName = null;
            try {
                pageProviderName = this.getTreeManager().getPageProviderName("publication");
                sorter = this.getTreeManager().getSorter("publication");
            }
            catch (Exception e) {
                log.error((Object)"Could not fetch filter, sorter or node type for tree ", (Throwable)e);
            }
            dtn = new DocumentTreeNodeImpl(document.getSessionId(), document, filter, null, sorter, pageProviderName);
        }
        return dtn;
    }

    public String getRelativePath(DocumentModel document) {
        DocumentModel sectionPublicationArea = ((ToutaticeNavigationContext)this.navigationContext).getSectionPublicationArea(document);
        if (ToutaticeGlobalConst.NULL_DOCUMENT_MODEL.getType().equals(sectionPublicationArea.getType())) {
            sectionPublicationArea = null;
        }
        List pathSegments = ((ToutaticeDocumentActions)this.documentActions).getDocumentPathSegments(document, sectionPublicationArea);
        return ToutaticeAdministrationPublishActions.formatPathFragments((List)pathSegments);
    }

    public DocumentModel getParentCfgOwner(DocumentModel document) {
        return ((ToutaticeRemoteRootSectionsFinder)this.getRootFinder()).getParentCfgOwner();
    }

    public DocumentModelList getSelectedSections() {
        return this.getSelectedSections("ALL");
    }

    public DocumentModelList getSelectedSections(String type) {
        DocumentModelListImpl list = new DocumentModelListImpl();
        try {
            DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
            return ((ToutaticeRemoteRootSectionsFinder)this.getRootFinder()).getSectionRootsForWorkspace(currentDocument, true, ToutaticeRemoteRootSectionsFinder.ROOT_SECTION_TYPE.valueOf(type));
        }
        catch (Exception e) {
            log.warn((Object)("Failed to list the sections, error: " + e.getMessage()));
            return list;
        }
    }

    public void applySectionsHeritage() {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        if (!currentDocument.hasSchema("publishing")) {
            return;
        }
        try {
            DocumentModelList parentsList = ToutaticeDocumentHelper.getParentList((CoreSession)this.documentManager, (DocumentModel)currentDocument, (Filter)new filterPublicationSpace(), (boolean)false);
            if (null != parentsList && 0 < parentsList.size()) {
                DocumentModel parent = (DocumentModel)parentsList.get(0);
                String[] parentSectionIds = ToutaticeDocumentHelper.filterLifeCycleStateDocuments((CoreSession)this.documentManager, (String[])((String[])parent.getPropertyValue("publish:sections")), Arrays.asList(ACCEPTED_LIFE_CYCLE_STATES), null);
                if (null != parentSectionIds && 0 < parentSectionIds.length) {
                    String[] currentDocumentSectionIds = (String[])currentDocument.getPropertyValue("publish:sections");
                    if (null != currentDocumentSectionIds && 0 < currentDocumentSectionIds.length) {
                        int i;
                        HashMap<String, String> sectionsIdMap = new HashMap<String, String>();
                        for (i = 0; i < currentDocumentSectionIds.length; ++i) {
                            sectionsIdMap.put(currentDocumentSectionIds[i], "");
                        }
                        for (i = 0; i < parentSectionIds.length; ++i) {
                            sectionsIdMap.put(parentSectionIds[i], "");
                        }
                        currentDocument.setPropertyValue("publish:sections", (Serializable)sectionsIdMap.keySet().toArray(new String[sectionsIdMap.size()]));
                    } else {
                        currentDocument.setPropertyValue("publish:sections", (Serializable)parentSectionIds);
                    }
                    this.documentManager.saveDocument(currentDocument);
                    this.getRootFinder().reset();
                    this.resetUserRootSectionsModel();
                    Object[] params = new Object[]{parentSectionIds.length};
                    this.facesMessages.add(StatusMessage.Severity.INFO, (String)this.resourcesAccessor.getMessages().get("acaren.info.admin.publication.sections.heritage"), params);
                } else {
                    this.facesMessages.add(StatusMessage.Severity.INFO, (String)this.resourcesAccessor.getMessages().get("acaren.info.admin.publication.sections.heritage.none"), new Object[0]);
                }
            } else {
                this.facesMessages.add(StatusMessage.Severity.INFO, (String)this.resourcesAccessor.getMessages().get("acaren.info.admin.publication.sections.heritage.nospace"), new Object[0]);
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed to apply the section heritage, error: " + e.getMessage()));
        }
    }

    public void propagateSections() {
        try {
            DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
            String[] sectionIdsList = (String[])currentDocument.getPropertyValue("publish:sections");
            if (null != sectionIdsList && 0 < sectionIdsList.length) {
                ToutaticeNotifyEventHelper.notifyEvent((CoreSession)this.documentManager, (String)"propagateSections", (DocumentModel)currentDocument, null);
                this.facesMessages.add(StatusMessage.Severity.INFO, (String)this.resourcesAccessor.getMessages().get("toutatice.info.admin.publication.sections.propagate"), new Object[0]);
                log.info((Object)("D\u00e9marrage du processus de propagation des sections depuis le document '" + currentDocument.getTitle() + "'"));
            } else {
                this.facesMessages.add(StatusMessage.Severity.WARN, (String)this.resourcesAccessor.getMessages().get("toutatice.info.admin.publication.sections.propagate.empty"), new Object[0]);
            }
        }
        catch (ClientException e) {
            log.error((Object)("Failed to launch the process to propagate the sections, error: " + e.getMessage()));
        }
    }

    @Observer(value={"sectionModified"}, create=false)
    public void resetRootSectionsContext() {
        this.getRootFinder().reset();
    }

    private class filterPublicationSpace
    implements Filter {
        private static final long serialVersionUID = 1L;

        private filterPublicationSpace() {
        }

        public boolean accept(DocumentModel document) {
            return document.hasSchema("publishing");
        }
    }
}

