/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.web.publication.validation;

import fr.toutatice.ecm.platform.core.constants.ToutaticeGlobalConst;
import fr.toutatice.ecm.platform.core.helper.ToutaticeDocumentHelper;
import fr.toutatice.ecm.platform.helper.ToutaticePublishHelper;
import fr.toutatice.ecm.platform.web.publication.ToutaticePublishActionsBean;
import fr.toutatice.ecm.platform.web.publication.finder.ToutaticeRemoteRootSectionsFinder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.core.Events;
import org.jboss.seam.international.StatusMessage;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.impl.DocumentLocationImpl;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.platform.contentview.seam.ContentViewActions;
import org.nuxeo.ecm.platform.publisher.api.PublicationNode;
import org.nuxeo.ecm.platform.publisher.api.PublicationTree;
import org.nuxeo.ecm.platform.publisher.api.PublicationTreeNotAvailable;
import org.nuxeo.ecm.platform.publisher.api.PublishedDocument;
import org.nuxeo.ecm.platform.publisher.api.PublisherException;
import org.nuxeo.ecm.platform.publisher.api.PublisherService;
import org.nuxeo.ecm.platform.publisher.api.PublishingEvent;
import org.nuxeo.ecm.platform.publisher.helper.RootSectionFinder;
import org.nuxeo.ecm.platform.publisher.impl.core.SimpleCorePublishedDocument;
import org.nuxeo.ecm.platform.publisher.web.PublishActionsBean;
import org.nuxeo.ecm.platform.ui.web.util.ComponentUtils;
import org.nuxeo.runtime.api.Framework;

@Name(value="publishActions")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=32)
public class ToutaticeRemotePublishActionsBean
extends ToutaticePublishActionsBean {
    private static final Log log = LogFactory.getLog(ToutaticeRemotePublishActionsBean.class);
    private static final long serialVersionUID = 1L;
    private static final String CST_DEFAULT_DOCUMENT_SELECTION_REJECT_COMMENT = "Rejet de la demande de publication";
    @In(create=true)
    protected transient CoreSession documentManager;
    @In(create=true)
    protected ContentViewActions contentViewActions;
    private transient DocumentModel publishableDocInSection = null;
    private transient Map<String, PublishedDocument> publishedDocInSectionMap = null;
    private transient Map<String, PublishedDocument> publishedDocModelMap = null;
    private transient Map<String, PublicationNode> PublicationNodeMap = null;
    private transient Map<String, PublicationTree> PublicationTreeMap = null;
    private transient Map<String, Boolean> hasValidationTaskMap = null;
    private transient Map<String, Boolean> canManagePublishingMap = null;
    private transient Map<String, Boolean> mapIsPublishedDoc = null;
    private transient Map<String, List<PublishedDocument>> publishedDocsOfTreeMap = null;

    public boolean isPublishedDocument() {
        DocumentModel currentDoc = this.navigationContext.getCurrentDocument();
        return !currentDoc.isVersion() && currentDoc.hasFacet("isRemoteProxy");
    }

    public boolean isRemoteProxyInSelection() {
        boolean status = false;
        List docsList = this.documentsListsManager.getWorkingList("CURRENT_SELECTION");
        if (null != docsList && 0 < docsList.size()) {
            for (DocumentModel doc : docsList) {
                status = this.isRemoteProxy(doc);
                if (!status) continue;
                status = true;
                break;
            }
        }
        return status;
    }

    public boolean isPublicationAvailable() {
        boolean status;
        block2: {
            status = false;
            try {
                status = this.getPublishableDoc() != null;
            }
            catch (ClientException e) {
                String docName;
                DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
                String string = docName = null != currentDocument ? currentDocument.getName() : "<unknown>";
                if (!log.isDebugEnabled()) break block2;
                log.debug((Object)("Failed to evaluate the condition 'isPublicationAvailable', for the document '" + docName + "', error: " + e.getMessage()));
            }
        }
        return status;
    }

    public boolean canPublishTo(DocumentModel section) throws ClientException {
        boolean status = false;
        try {
            DocumentModel publishableDoc = this.getPublishableDoc();
            if (null != publishableDoc) {
                PublishedDocument publishedDoc = this.getPublishedDoc(section);
                if (null == publishedDoc) {
                    status = true;
                } else {
                    DocumentRef srcDocRef = publishedDoc.getSourceDocumentRef();
                    DocumentModel publishedDocModel = this.documentManager.getDocument(srcDocRef);
                    if (ToutaticeDocumentHelper.DocumentVersionComparator.isNewer((DocumentModel)publishedDocModel, (DocumentModel)publishableDoc)) {
                        status = true;
                    }
                }
                if (status) {
                    PublicationNode sectionNode = this.wrapToPublicationNode(section);
                    status = super.canPublishTo(sectionNode);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed to execute 'canPublishTo' on section '" + section.getTitle() + "', error: " + e.getMessage()));
            status = false;
        }
        return status;
    }

    public boolean canUnpublishFrom(DocumentModel section) throws ClientException {
        boolean status = false;
        try {
            PublishedDocument publishedDoc = this.getPublishedDoc(section);
            if (null != publishedDoc) {
                status = super.canUnpublish(publishedDoc);
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed to execute 'canUnpublishFrom' on section '" + section.getTitle() + "', error: " + e.getMessage()));
        }
        return status;
    }

    public String doPublish(DocumentModel section) throws ClientException {
        String status = this.doPublishVersion(section);
        this.removeFromPublishContext(section);
        return status;
    }

    public String doPublishVersion(DocumentModel section) throws ClientException {
        String comment;
        PublishedDocument publishedDocument;
        PublicationTree tree = this.getCurrentPublicationTreeForPublishing();
        if (tree == null) {
            return null;
        }
        PublicationNode publicationNode = this.wrapToPublicationNode(section);
        DocumentModel publishableDoc = this.getPublishableDoc();
        try {
            String formerProxyName = null;
            DocumentModel cd = this.navigationContext.getCurrentDocument();
            DocumentModel cds = this.documentManager.getSourceDocument(cd.getRef());
            DocumentModelList proxies = this.documentManager.getProxies(cds.getRef(), section.getRef());
            if (proxies != null) {
                for (DocumentModel p : proxies) {
                    PublishedDocument pd = tree.wrapToPublishedDocument(p);
                    if (pd.isPending()) continue;
                    formerProxyName = p.getName();
                }
            }
            publishedDocument = tree.publish(publishableDoc, publicationNode, this.publicationParameters);
            UnrestrictedSetProxyNameRunner runner = new UnrestrictedSetProxyNameRunner(this.documentManager, publishedDocument, formerProxyName, section);
            runner.runUnrestricted();
        }
        catch (PublisherException e) {
            log.error((Object)e, (Throwable)e);
            this.facesMessages.addFromResourceBundle(StatusMessage.Severity.ERROR, (String)this.messages.get("document_published"), new Object[]{this.messages.get(e.getMessage())});
            return null;
        }
        FacesContext context = FacesContext.getCurrentInstance();
        if (publishedDocument.isPending()) {
            comment = ComponentUtils.translate((FacesContext)context, (String)"publishing.waiting", (Object[])new Object[]{publicationNode.getPath(), tree.getConfigName()});
            Events.instance().raiseEvent("documentSubmitedForPublication", new Object[0]);
            this.notifyEvent(PublishingEvent.documentWaitingPublication.name(), null, comment, null, publishableDoc);
            this.facesMessages.addFromResourceBundle(StatusMessage.Severity.INFO, (String)this.messages.get("document_submitted_for_publication"), new Object[]{this.messages.get(publishableDoc.getType())});
        } else {
            comment = ComponentUtils.translate((FacesContext)context, (String)"publishing.done", (Object[])new Object[]{publicationNode.getPath(), tree.getConfigName()});
            Events.instance().raiseEvent("documentPublished", new Object[0]);
            this.notifyEvent(PublishingEvent.documentPublished.name(), null, comment, null, publishableDoc);
            this.facesMessages.addFromResourceBundle(StatusMessage.Severity.INFO, (String)this.messages.get("document_published"), new Object[]{this.messages.get(publishableDoc.getType())});
        }
        return null;
    }

    public String unPublishFrom(DocumentModel section) throws ClientException {
        String result = null;
        PublishedDocument publishedDoc = this.getPublishedDoc(section);
        if (null != publishedDoc) {
            result = super.unPublish(publishedDoc);
            this.removeFromPublishContext(section);
        }
        return result;
    }

    public DocumentModelList filterEmptySections(DocumentModelList sections) {
        DocumentModelListImpl notEmptySections = new DocumentModelListImpl();
        try {
            if (null != sections) {
                for (DocumentModel section : sections) {
                    if (null == this.getPublishedDoc(section)) continue;
                    notEmptySections.add((Object)section);
                }
            }
        }
        catch (ClientException ce) {
            log.error((Object)("Failed to list the sections containing a published document, error: " + ce.getMessage()));
        }
        return notEmptySections;
    }

    public String getPublishedVersion(DocumentModel section) throws ClientException {
        String versionLabel = "";
        PublishedDocument publishedDoc = this.getPublishedDoc(section);
        if (null != publishedDoc) {
            versionLabel = publishedDoc.getSourceVersionLabel();
        }
        return versionLabel;
    }

    public String getPublishableVersion(DocumentModel section) throws ClientException {
        String versionLabel = "";
        DocumentModel publishableDoc = this.getPublishableDoc();
        if (this.canPublishTo(section)) {
            if (null != publishableDoc) {
                versionLabel = publishableDoc.getVersionLabel();
            }
        } else {
            if (null == publishableDoc) {
                versionLabel = (String)this.messages.get("toutatice.label.publish.not.available");
            }
            if (!this.hasPublicationPermission(section)) {
                String label = (String)this.messages.get("toutatice.label.publish.no.permission");
                versionLabel = versionLabel + (versionLabel.isEmpty() ? label : ", " + label.toLowerCase());
            }
        }
        return versionLabel;
    }

    private boolean hasPublicationPermission(DocumentModel section) {
        boolean status = false;
        try {
            if (this.documentManager.hasPermission(section.getRef(), "Write") || this.documentManager.hasPermission(section.getRef(), "CanAskForPublishing")) {
                status = true;
            }
        }
        catch (ClientException e) {
            log.debug((Object)("Failed to check the permission on the publication sections '" + section.getName() + "'"));
        }
        return status;
    }

    public String getActionLabel(DocumentModel section) throws ClientException {
        String actionLabel = (String)this.messages.get("label.publish.publish");
        PublishedDocument publishedDoc = this.getPublishedDoc(section);
        if (null != publishedDoc) {
            actionLabel = (String)this.messages.get("label.publish.publish.again");
        }
        return actionLabel;
    }

    public PublishedDocument getPublishedDoc(DocumentModel section) throws ClientException {
        if (null == this.publishedDocInSectionMap) {
            this.publishedDocInSectionMap = new HashMap<String, PublishedDocument>();
        }
        if (!this.publishedDocInSectionMap.containsKey(section.getId())) {
            this.publishedDocInSectionMap.put(section.getId(), ToutaticeGlobalConst.NULL_PUBLISHED_DOCUMENT_MODEL);
            PublishedDocument publishedDoc = this.findPublishedDocInSection(section, null);
            if (publishedDoc != null) {
                this.publishedDocInSectionMap.put(section.getId(), publishedDoc);
            }
        }
        PublishedDocument pd = this.publishedDocInSectionMap.get(section.getId());
        return !ToutaticeGlobalConst.NULL_PUBLISHED_DOCUMENT_MODEL.getPath().equals(pd.getPath()) ? pd : null;
    }

    private PublishedDocument findPublishedDocInSection(DocumentModel section, DocumentModel doc) throws ClientException {
        List<PublishedDocument> publishedDocList = null;
        PublishedDocument res = null;
        String treeName = this.getPublicationTreeNameFromSectionDocument(section);
        if (StringUtils.isNotBlank((String)treeName) && null != (publishedDocList = doc == null ? this.getPublishedDocumentsFor(treeName) : this.findPublishedDocsOfTree(treeName, doc)) && !publishedDocList.isEmpty()) {
            for (PublishedDocument publishedDoc : publishedDocList) {
                String pdParentPath = publishedDoc.getParentPath();
                if (!pdParentPath.equals(section.getPath().toString())) continue;
                res = publishedDoc;
                break;
            }
        }
        return res;
    }

    public List<PublishedDocument> getPublishedDocumentsFor(String treeName, DocumentModel doc) throws ClientException {
        if (treeName == null || "".equals(treeName)) {
            return null;
        }
        try {
            PublicationTree tree = this.publisherService.getPublicationTree(treeName, this.documentManager, null);
            return tree.getExistingPublishedDocument((DocumentLocation)new DocumentLocationImpl(doc));
        }
        catch (PublicationTreeNotAvailable e) {
            return null;
        }
    }

    private String getPublicationTreeNameFromSectionDocument(DocumentModel section) {
        String treeName = null;
        try {
            PublicationNode treeNode = this.wrapToPublicationNode(section);
            treeName = treeNode.getTreeConfigName();
        }
        catch (Exception e) {
            log.error((Object)("Failed to get the publication tree name for the section '" + section.getName() + "', error: " + e.getMessage()));
        }
        return treeName;
    }

    private DocumentModel getPublishableDoc() throws ClientException {
        DocumentModel currentDoc;
        if (null == this.publishableDocInSection && null != (currentDoc = this.navigationContext.getCurrentDocument())) {
            this.publishableDocInSection = "approved".equals(currentDoc.getCurrentLifeCycleState()) ? currentDoc : ToutaticeDocumentHelper.getLatestDocumentVersion((DocumentModel)currentDoc, (CoreSession)this.documentManager);
        }
        return this.publishableDocInSection;
    }

    private void removeFromPublishContext(DocumentModel section) {
        this.publishedDocInSectionMap.remove(section.getId());
        String treeName = this.getPublicationTreeNameFromSectionDocument(section);
        this.publishedDocsOfTreeMap.remove(treeName);
    }

    @Observer(value={"documentSelectionChanged", "domainSelectionChanged", "contentRootSelectionChanged", "documentPublicationApproved", "documentPublicationRejected", "documentChanged", "goHome"}, create=false)
    public void resetPublishContext() {
        this.publishableDocInSection = null;
        if (null != this.publishedDocInSectionMap) {
            this.publishedDocInSectionMap.clear();
        }
        if (null != this.publishedDocsOfTreeMap) {
            this.publishedDocsOfTreeMap.clear();
        }
        if (null != this.publishedDocModelMap) {
            this.publishedDocModelMap.clear();
        }
        if (null != this.PublicationNodeMap) {
            this.PublicationNodeMap.clear();
        }
        if (null != this.PublicationTreeMap) {
            this.PublicationTreeMap.clear();
        }
        if (null != this.hasValidationTaskMap) {
            this.hasValidationTaskMap.clear();
        }
        if (null != this.canManagePublishingMap) {
            this.canManagePublishingMap.clear();
        }
        if (null != this.mapIsPublishedDoc) {
            this.mapIsPublishedDoc.clear();
        }
    }

    public boolean checkDocumentLifeCycle(String validStates) {
        boolean res = false;
        String currentLifeCycleState = null;
        List currentDocumentSelection = this.documentsListsManager.getWorkingList("CURRENT_SELECTION");
        try {
            DocumentModel documentModel;
            Iterator iterator = currentDocumentSelection.iterator();
            while (iterator.hasNext() && (res = validStates.contains(currentLifeCycleState = (documentModel = (DocumentModel)iterator.next()).getCurrentLifeCycleState()))) {
            }
        }
        catch (ClientException e) {
            log.error((Object)("Failed to check currentLifeCycleState, error: " + e.getMessage()));
        }
        return res;
    }

    public String getParentFormattedPath(DocumentModel document) throws ClientException {
        String path = "";
        DocumentModel parentModel = this.getDocumentModelForParent(document);
        if (null != parentModel) {
            path = super.getFormattedPath(parentModel);
        }
        return path;
    }

    public DocumentModel getDocumentModelForParent(DocumentModel document) throws ClientException {
        DocumentRef parentRef = document.getParentRef();
        if (null != parentRef) {
            return this.documentManager.getDocument(parentRef);
        }
        return null;
    }

    public void unpublishFromProxy(DocumentModel proxy) throws ClientException {
        ArrayList<DocumentModel> list = new ArrayList<DocumentModel>();
        list.add(proxy);
        super.unpublish(list);
    }

    public boolean getIsWaitingForPublication() throws ClientException {
        boolean isWaitingForPublication;
        block3: {
            isWaitingForPublication = false;
            try {
                List selectedDocuments = this.documentsListsManager.getWorkingList("CURRENT_SELECTION_SECTIONS");
                if (selectedDocuments == null || selectedDocuments.isEmpty()) break block3;
                for (DocumentModel document : selectedDocuments) {
                    if (document.hasFacet("Folderish")) continue;
                    isWaitingForPublication = true;
                    PublishedDocument publishedDocument = this.getPublishedDocumentModel(document);
                    PublicationTree tree = this.getPublicationTreeFor(document);
                    boolean canManagePublishing = tree.canManagePublishing(publishedDocument);
                    isWaitingForPublication = publishedDocument.isPending() && canManagePublishing;
                    if (isWaitingForPublication) continue;
                    break;
                }
            }
            catch (Exception e) {
                log.error((Object)("Failed to check if the document is waiting for publication, error: " + e.getMessage()));
            }
        }
        return isWaitingForPublication;
    }

    public boolean getCanUnpublishSectionSelection() throws ClientException {
        boolean status = false;
        List selectedDocuments = this.documentsListsManager.getWorkingList("CURRENT_SELECTION_SECTIONS");
        if (selectedDocuments != null && !selectedDocuments.isEmpty()) {
            status = true;
            for (DocumentModel document : selectedDocuments) {
                if (!this.isPending(document)) continue;
                status = false;
                break;
            }
        }
        return status;
    }

    public void approveDocumentsFromCurrentSelection() throws ClientException {
        List selectedDocuments = this.documentsListsManager.getWorkingList("CURRENT_SELECTION_SECTIONS");
        if (selectedDocuments != null && !selectedDocuments.isEmpty()) {
            for (DocumentModel document : selectedDocuments) {
                this.approveDocument(document);
            }
            this.refreshUI();
        }
    }

    public void rejectDocumentsFromCurrentSelection() throws ClientException {
        List selectedDocuments = this.documentsListsManager.getWorkingList("CURRENT_SELECTION_SECTIONS");
        if (selectedDocuments != null && !selectedDocuments.isEmpty()) {
            this.publishingComment = CST_DEFAULT_DOCUMENT_SELECTION_REJECT_COMMENT;
            for (DocumentModel document : selectedDocuments) {
                this.rejectDocument(document);
            }
            this.refreshUI();
        }
    }

    public String approveDocument() throws ClientException {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        return this.approveDocument(currentDocument);
    }

    public String rejectDocument() throws ClientException {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        return this.rejectDocument(currentDocument);
    }

    public String approveDocument(DocumentModel document) throws ClientException {
        PublicationTree tree = this.getPublicationTreeFor(document);
        PublishedDocument publishedDocument = tree.wrapToPublishedDocument(document);
        String formerProxyName = null;
        DocumentModelList proxies = this.documentManager.getProxies(document.getRef(), document.getParentRef());
        if (proxies != null) {
            for (DocumentModel p : proxies) {
                PublishedDocument pd = tree.wrapToPublishedDocument(p);
                if (pd.isPending()) continue;
                formerProxyName = p.getName();
            }
        }
        tree.validatorPublishDocument(publishedDocument, this.publishingComment);
        String newProxyName = formerProxyName;
        if (StringUtils.isBlank(newProxyName)) {
            DocumentRef sdRef = ((SimpleCorePublishedDocument)publishedDocument).getSourceDocumentRef();
            DocumentModel dm = this.documentManager.getSourceDocument(sdRef);
            newProxyName = dm.getName();
        }
        if (!document.getName().equals(newProxyName)) {
            this.documentManager.move(document.getRef(), document.getParentRef(), newProxyName);
        }
        if (!this.navigationContext.getCurrentDocument().isFolder()) {
            this.navigationContext.navigateToId(document.getId());
        }
        try {
            FacesContext context = FacesContext.getCurrentInstance();
            String comment = this.publishingComment != null && this.publishingComment.length() > 0 ? ComponentUtils.translate((FacesContext)context, (String)"publishing.approved.with.comment", (Object[])new Object[]{publishedDocument.getParentPath(), tree.getConfigName(), this.publishingComment}) : ComponentUtils.translate((FacesContext)context, (String)"publishing.approved.without.comment", (Object[])new Object[]{publishedDocument.getParentPath(), tree.getConfigName()});
            PublishActionsBean.ApproverWithoutRestriction approver = new PublishActionsBean.ApproverWithoutRestriction((PublishActionsBean)this, publishedDocument, comment, this.documentManager);
            if (this.documentManager.hasPermission(publishedDocument.getSourceDocumentRef(), "Write")) {
                approver.run();
            } else {
                approver.runUnrestricted();
            }
        }
        catch (Exception e) {
            log.warn((Object)("Faied to approve the document '" + document.getTitle() + "'. It may point to a no more existing source document, error: " + e.getMessage()));
        }
        Events.instance().raiseEvent("documentPublished", new Object[0]);
        Events.instance().raiseEvent("documentPublicationApproved", new Object[0]);
        return null;
    }

    @Observer(value={"documentWaitingPublication", "documentPublicationApproved", "documentPublicationRejected", "documentPublished", "documentUnpublished"})
    public void onDocumentChanged() {
        this.contentViewActions.refreshOnSeamEvent("documentPublicationEvent");
        this.contentViewActions.resetPageProviderOnSeamEvent("documentPublicationEvent");
    }

    public String rejectDocument(DocumentModel document) throws ClientException {
        if (StringUtils.isBlank((String)this.publishingComment)) {
            this.facesMessages.addToControl("publishingComment", StatusMessage.Severity.ERROR, (String)this.messages.get("label.publishing.reject.user.comment.mandatory"), new Object[0]);
            return null;
        }
        try {
            PublicationTree tree = this.getPublicationTreeFor(document);
            PublishedDocument publishedDocument = tree.wrapToPublishedDocument(document);
            tree.validatorRejectPublication(publishedDocument, this.publishingComment);
            FacesContext context = FacesContext.getCurrentInstance();
            String comment = this.publishingComment != null && this.publishingComment.length() > 0 ? ComponentUtils.translate((FacesContext)context, (String)"publishing.rejected.with.comment", (Object[])new Object[]{publishedDocument.getParentPath(), tree.getConfigName(), this.publishingComment}) : ComponentUtils.translate((FacesContext)context, (String)"publishing.rejected.without.comment", (Object[])new Object[]{publishedDocument.getParentPath(), tree.getConfigName()});
            RejectWithoutRestrictionRunner runner = new RejectWithoutRestrictionRunner(this.documentManager, publishedDocument, comment);
            if (this.documentManager.hasPermission(publishedDocument.getSourceDocumentRef(), "Read")) {
                runner.run();
            } else {
                runner.runUnrestricted();
            }
        }
        catch (Exception e) {
            log.warn((Object)("Faied to reject the document '" + document.getTitle() + "'. It may point to a no more existing source document, error: " + e.getMessage()));
        }
        Events.instance().raiseEvent("documentPublicationRejected", new Object[0]);
        return this.navigationContext.navigateToRef(document.getParentRef());
    }

    public boolean isPending() throws ClientException {
        return this.isPending(this.navigationContext.getCurrentDocument());
    }

    public boolean isPending(DocumentModel document) throws ClientException {
        PublishedDocument publishedDocument = this.getPublishedDocumentModel(document);
        return null != publishedDocument ? publishedDocument.isPending() : false;
    }

    public void unPublish(DocumentModel document) throws ClientException {
        if (this.isPending(document)) {
            this.setPublishingComment(CST_DEFAULT_DOCUMENT_SELECTION_REJECT_COMMENT);
            this.rejectDocument(document);
        } else {
            this.unPublish(this.getPublishedDocumentModel(document));
        }
    }

    public boolean isAtLeastOnePublished() throws ClientException {
        List docsList;
        boolean status = false;
        if (this.mapIsPublishedDoc == null) {
            this.mapIsPublishedDoc = new HashMap<String, Boolean>();
        }
        if (null != (docsList = this.documentsListsManager.getWorkingList("CURRENT_SELECTION")) && 0 < docsList.size()) {
            block0: for (DocumentModel doc : docsList) {
                if (!this.mapIsPublishedDoc.containsKey(doc.getId())) {
                    RootSectionFinder rsf = this.publisherService.getRootSectionFinder(this.documentManager);
                    DocumentModelList lstEspPublication = ((ToutaticeRemoteRootSectionsFinder)rsf).getSectionRootsForWorkspace(doc, true, ToutaticeRemoteRootSectionsFinder.ROOT_SECTION_TYPE.valueOf("ALL"));
                    for (DocumentModel section : lstEspPublication) {
                        status = this.findPublishedDocInSection(section, doc) != null;
                        this.mapIsPublishedDoc.put(doc.getId(), status);
                        if (!status) continue;
                        continue block0;
                    }
                    continue;
                }
                if (!this.mapIsPublishedDoc.get(doc.getId()).booleanValue()) continue;
                status = true;
                break;
            }
        }
        return status;
    }

    public List<PublishedDocument> getPublishedDocumentsFor(String treeName) throws ClientException {
        List<Object> filteredList = new ArrayList();
        try {
            if (null == this.publishedDocsOfTreeMap) {
                this.publishedDocsOfTreeMap = new HashMap<String, List<PublishedDocument>>();
            }
            if (!this.publishedDocsOfTreeMap.containsKey(treeName)) {
                DocumentModel currentDoc = this.navigationContext.getCurrentDocument();
                filteredList = this.findPublishedDocsOfTree(treeName, currentDoc);
                this.publishedDocsOfTreeMap.put(treeName, filteredList);
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed to get the published documents for the tree name '" + treeName + "', error: " + e.getMessage()));
        }
        return this.publishedDocsOfTreeMap.get(treeName);
    }

    private List<PublishedDocument> findPublishedDocsOfTree(String treeName, DocumentModel doc) throws ClientException {
        ArrayList<PublishedDocument> filteredList = new ArrayList<PublishedDocument>();
        DocumentModel docSrc = this.documentManager.getDocument((DocumentRef)new IdRef(doc.getSourceId()));
        String sourceDocParentPath = docSrc.getPath().removeLastSegments(1).toString();
        List<PublishedDocument> rawList = this.getPublishedDocumentsFor(treeName, doc);
        for (PublishedDocument publishedDoc : rawList) {
            String publishedDocParentPath = publishedDoc.getParentPath();
            if (publishedDocParentPath.equals(sourceDocParentPath)) continue;
            filteredList.add(publishedDoc);
        }
        return filteredList;
    }

    private PublishedDocument getPublishedDocumentModel(DocumentModel document) {
        if (!document.isProxy()) {
            return null;
        }
        if (null == this.publishedDocModelMap) {
            this.publishedDocModelMap = new HashMap<String, PublishedDocument>();
        }
        try {
            PublicationTree tree;
            PublishedDocument publishedDocument;
            if (null == this.publishedDocModelMap.get(document.getId()) && null != (publishedDocument = (tree = this.getPublicationTreeFor(document)).wrapToPublishedDocument(document))) {
                this.publishedDocModelMap.put(document.getId(), publishedDocument);
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed to get the published document model of the document '" + document.getName() + "', error: " + e.getMessage()));
        }
        return this.publishedDocModelMap.get(document.getId());
    }

    public void refreshUI() throws ClientException {
        this.documentsListsManager.resetWorkingList("CURRENT_SELECTION_SECTIONS");
        Events.instance().raiseEvent("documentChildrenChanged", new Object[0]);
    }

    private PublicationTree getPublicationTreeFor(DocumentModel document) throws ClientException {
        if (null == this.PublicationTreeMap) {
            this.PublicationTreeMap = new HashMap<String, PublicationTree>();
        }
        if (null == this.PublicationTreeMap.get(document.getId())) {
            PublicationTree tree = this.publisherService.getPublicationTreeFor(document, this.documentManager);
            this.PublicationTreeMap.put(document.getId(), tree);
        }
        return this.PublicationTreeMap.get(document.getId());
    }

    public boolean canManagePublishing() throws ClientException {
        DocumentModel document;
        if (null == this.canManagePublishingMap) {
            this.canManagePublishingMap = new HashMap<String, Boolean>();
        }
        if (null == this.canManagePublishingMap.get((document = this.navigationContext.getCurrentDocument()).getId())) {
            boolean status = super.canManagePublishing();
            this.canManagePublishingMap.put(document.getId(), status);
        }
        return this.canManagePublishingMap.get(document.getId());
    }

    public boolean hasValidationTask() throws ClientException {
        DocumentModel document;
        if (null == this.hasValidationTaskMap) {
            this.hasValidationTaskMap = new HashMap<String, Boolean>();
        }
        if (null == this.hasValidationTaskMap.get((document = this.navigationContext.getCurrentDocument()).getId())) {
            boolean status = super.hasValidationTask();
            this.hasValidationTaskMap.put(document.getId(), status);
        }
        return this.hasValidationTaskMap.get(document.getId());
    }

    private PublicationNode wrapToPublicationNode(DocumentModel document) throws ClientException {
        if (null == this.PublicationNodeMap) {
            this.PublicationNodeMap = new HashMap<String, PublicationNode>();
        }
        if (null == this.PublicationNodeMap.get(document.getId())) {
            PublicationNode node = this.publisherService.wrapToPublicationNode(document, this.documentManager);
            this.PublicationNodeMap.put(document.getId(), node);
        }
        return this.PublicationNodeMap.get(document.getId());
    }

    public boolean getCanPublishToFirstSection() throws ClientException {
        DocumentModel section = null;
        DocumentModel doc = this.navigationContext.getCurrentDocument();
        PublisherService ps = (PublisherService)Framework.getLocalService(PublisherService.class);
        section = ToutaticePublishHelper.getFirstSection(doc, ps, this.documentManager);
        boolean status = false;
        PublishedDocument publishedDoc = this.getPublishedDoc(section);
        if (null == publishedDoc) {
            status = true;
        } else {
            DocumentRef srcDocRef = publishedDoc.getSourceDocumentRef();
            DocumentModel publishedDocModel = this.documentManager.getDocument(srcDocRef);
            if (ToutaticeDocumentHelper.DocumentVersionComparator.isNewer((DocumentModel)publishedDocModel, (DocumentModel)doc)) {
                status = true;
            }
        }
        return status;
    }

    protected List<String> filterEmptyTrees(Collection<String> trees) throws PublicationTreeNotAvailable, ClientException {
        ArrayList<String> filteredTrees = new ArrayList<String>();
        ToutaticeRemoteRootSectionsFinder finder = new ToutaticeRemoteRootSectionsFinder(this.documentManager);
        DocumentModelList accessibleSections = finder.getAccessibleSectionRoots(this.navigationContext.getCurrentDocument());
        for (String tree : trees) {
            try {
                PublicationTree pTree;
                String treeDomain = StringUtils.substringAfter((String)tree, (String)"-");
                boolean inDomain = false;
                for (DocumentModel section : accessibleSections) {
                    if (!section.getPathAsString().startsWith("/" + treeDomain)) continue;
                    inDomain = true;
                }
                if (!inDomain) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("#filterEmptyTrees: == [LOOP: Selected tree]: " + tree));
                }
                if ((pTree = this.publisherService.getPublicationTree(tree, this.documentManager, null, this.navigationContext.getCurrentDocument())) == null) continue;
                if (pTree.getTreeType().equals("ToutaticeRootSectionsPublicationTree")) {
                    if (pTree.getChildrenNodes().size() <= 0) continue;
                    filteredTrees.add(tree);
                    continue;
                }
                filteredTrees.add(tree);
            }
            catch (PublicationTreeNotAvailable e) {
                log.warn((Object)("Publication tree " + tree + " is not available : check config"));
                log.debug((Object)("Publication tree " + tree + " is not available : root cause is "), (Throwable)e);
            }
        }
        return filteredTrees;
    }

    private class RejectWithoutRestrictionRunner
    extends UnrestrictedSessionRunner {
        PublishedDocument publishedDocument;
        DocumentModel sourceDocument;
        String comment;
        DocumentModel liveVersion;

        public RejectWithoutRestrictionRunner(CoreSession session, PublishedDocument publishedDocument, String comment) {
            super(session);
            this.publishedDocument = publishedDocument;
            this.comment = comment;
        }

        public void run() throws ClientException {
            this.sourceDocument = this.session.getDocument(this.publishedDocument.getSourceDocumentRef());
            this.liveVersion = this.session.getDocument((DocumentRef)new IdRef(this.sourceDocument.getSourceId()));
            this.notifyRejectToSourceDocument();
        }

        private void notifyRejectToSourceDocument() throws ClientException {
            ToutaticeRemotePublishActionsBean.this.notifyEvent(PublishingEvent.documentPublicationRejected.name(), null, this.comment, null, this.sourceDocument);
            if (!this.sourceDocument.getRef().equals(this.liveVersion.getRef())) {
                ToutaticeRemotePublishActionsBean.this.notifyEvent(PublishingEvent.documentPublicationRejected.name(), null, this.comment, null, this.liveVersion);
            }
        }
    }

    private class UnrestrictedSetProxyNameRunner
    extends UnrestrictedSessionRunner {
        private SimpleCorePublishedDocument publishedDocument;
        private DocumentModel section;

        protected UnrestrictedSetProxyNameRunner(CoreSession session, PublishedDocument publishedDocument, String formerProxyName, DocumentModel section) {
            super(session);
            this.publishedDocument = (SimpleCorePublishedDocument)publishedDocument;
            this.section = section;
        }

        public void run() throws ClientException {
            DocumentModel proxy;
            DocumentRef sdRef = this.publishedDocument.getSourceDocumentRef();
            DocumentModel dm = this.session.getSourceDocument(sdRef);
            String newProxyName = dm.getName();
            if (this.publishedDocument.isPending()) {
                newProxyName = dm.getName() + ".pending";
            }
            if (!(proxy = this.publishedDocument.getProxy()).getName().equals(newProxyName)) {
                this.session.move(proxy.getRef(), this.section.getRef(), newProxyName);
            }
        }
    }
}

