/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.opentoutatice.sharing.operation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.core.util.DocumentHelper;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.impl.ListProperty;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.osivia.opentoutatice.sharing.operation.SharingRunner;

public class UpdateSharingPermissionsRunner
extends SharingRunner {
    private final String permission;
    private final String user;
    private final Boolean add;
    private final Boolean ban;

    public UpdateSharingPermissionsRunner(CoreSession session, DocumentModel document, String permission, String user, Boolean add, Boolean ban) {
        super(session, document);
        this.permission = permission;
        this.user = user;
        this.add = add;
        this.ban = ban;
    }

    public void run() throws ClientException {
        DocumentRef ref = this.document.getRef();
        ACP acp = this.session.getACP(ref);
        ACL acl = acp.getOrCreateACL("sharing");
        if (StringUtils.isEmpty((String)this.user)) {
            if (StringUtils.isEmpty((String)this.permission)) {
                acp.removeACL("sharing");
            } else {
                if (CollectionUtils.isNotEmpty((Collection)acl)) {
                    HashSet<String> users = new HashSet<String>();
                    for (ACE ace : acl.getACEs()) {
                        users.add(ace.getUsername());
                    }
                    ArrayList<ACE> aces = new ArrayList<ACE>(users.size());
                    for (String user : users) {
                        ACE ace;
                        ace = new ACE(user, this.permission);
                        aces.add(ace);
                    }
                    acl.setACEs(aces.toArray(new ACE[0]));
                }
                try {
                    DocumentHelper.setProperty((CoreSession)this.session, (DocumentModel)this.document, (String)"sharing:linkPermission", (String)this.permission);
                }
                catch (IOException e) {
                    throw new ClientException((Throwable)e);
                }
            }
        } else {
            if (BooleanUtils.isTrue((Boolean)this.add)) {
                if (!this.isBannedUser() || BooleanUtils.isFalse((Boolean)this.ban)) {
                    String permission = (String)((Object)this.document.getPropertyValue("sharing:linkPermission"));
                    this.removeUserAce(acl, this.user);
                    ACE ace = new ACE(this.user, permission);
                    acl.add((Object)ace);
                }
            } else if (BooleanUtils.isFalse((Boolean)this.add)) {
                this.removeUserAce(acl, this.user);
            }
            if (BooleanUtils.isTrue((Boolean)this.ban)) {
                if (!this.isBannedUser()) {
                    ListProperty bannedUsers = (ListProperty)this.document.getProperty("sharing:bannedUsers");
                    bannedUsers.addValue((Object)this.user);
                    this.document.setProperty("sharing", "bannedUsers", (Object)bannedUsers);
                    this.removeUserAce(acl, this.user);
                }
            } else if (BooleanUtils.isFalse((Boolean)this.ban) && this.isBannedUser()) {
                Property bannedUser = null;
                ListProperty bannedUsers = (ListProperty)this.document.getProperty("sharing:bannedUsers");
                Iterator iterator = bannedUsers.iterator();
                while (iterator.hasNext() && bannedUser == null) {
                    Property property = (Property)iterator.next();
                    String value = (String)((Object)property.getValue());
                    if (!StringUtils.equals((String)this.user, (String)value)) continue;
                    bannedUser = property;
                }
                if (bannedUser != null) {
                    bannedUsers.remove(bannedUser);
                    this.document.setProperty("sharing", "bannedUsers", (Object)bannedUsers);
                }
            }
        }
        this.session.setACP(ref, acp, true);
        this.session.saveDocument(this.document);
    }

    private void removeUserAce(ACL acl, String user) {
        ACE ace = this.getUserAce(acl, user);
        if (ace != null) {
            acl.remove((Object)ace);
        }
    }

    private ACE getUserAce(ACL acl, String user) {
        ACE result = null;
        if (CollectionUtils.isNotEmpty((Collection)acl)) {
            Iterator iterator = acl.iterator();
            while (iterator.hasNext() && result == null) {
                ACE ace = (ACE)iterator.next();
                if (!StringUtils.equals((String)user, (String)ace.getUsername())) continue;
                result = ace;
            }
        }
        return result;
    }

    private boolean isBannedUser() {
        List bannedUsers = (List)((Object)this.document.getPropertyValue("sharing:bannedUsers"));
        return CollectionUtils.isNotEmpty((Collection)bannedUsers) && bannedUsers.contains(this.user);
    }
}

