/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody.internal.web.html;

import java.io.IOException;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.bull.javamelody.JdbcWrapper;
import net.bull.javamelody.internal.common.I18N;
import net.bull.javamelody.internal.model.Collector;
import net.bull.javamelody.internal.model.CollectorServer;
import net.bull.javamelody.internal.model.Counter;
import net.bull.javamelody.internal.model.CounterRequest;
import net.bull.javamelody.internal.model.CounterRequestRumData;
import net.bull.javamelody.internal.model.DatabaseInformations;
import net.bull.javamelody.internal.model.Range;
import net.bull.javamelody.internal.web.html.HtmlAbstractReport;
import net.bull.javamelody.internal.web.html.HtmlCounterReport;
import net.bull.javamelody.internal.web.html.HtmlSourceReport;

class HtmlCounterRequestGraphReport
extends HtmlAbstractReport {
    private static final int MAX_REQUEST_NAME_LENGTH = 5000;
    private static final String SCRIPT_BEGIN = "<script type='text/javascript'>";
    private static final String SCRIPT_END = "</script>";
    private static int uniqueByPageAndGraphSequence;
    private final Range range;
    private final DecimalFormat systemErrorFormat = I18N.createPercentFormat();
    private final DecimalFormat nbExecutionsFormat = I18N.createPercentFormat();
    private final DecimalFormat integerFormat = I18N.createIntegerFormat();
    private List<Counter> counters;
    private Map<String, CounterRequest> requestsById;

    HtmlCounterRequestGraphReport(Range range, Writer writer) {
        super(writer);
        assert (range != null);
        this.range = range;
    }

    @Override
    void toHtml() {
        throw new UnsupportedOperationException();
    }

    void writeRequestGraph(String requestId, String requestName) throws IOException {
        HtmlCounterRequestGraphReport.incrementUniqueByPageAndGraphSequence();
        this.write("<a class='tooltip' href='?part=graph&amp;graph=");
        this.write(requestId);
        this.write("'");
        this.write(" onmouseover=\"document.getElementById('");
        String id = "id" + uniqueByPageAndGraphSequence;
        this.write(id);
        this.write("').src='?graph=");
        this.write(requestId);
        this.write("&amp;width=100&amp;height=50'; this.onmouseover=null;\" >");
        this.write("<em><img src='?resource=db.png' id='");
        this.write(id);
        this.write("' alt='graph'/></em>");
        if (requestName.length() <= 5000) {
            this.writeDirectly(HtmlCounterRequestGraphReport.htmlEncodeRequestName(requestId, requestName));
            this.write("</a>");
        } else {
            this.writeDirectly(HtmlCounterRequestGraphReport.htmlEncodeRequestName(requestId, requestName.substring(0, 5000)));
            this.write("</a>");
            this.write("<br/> ");
            String idToShow = "request-" + requestId;
            this.writeShowHideLink(idToShow, "#Details#");
            this.writeln("<div id='request-" + requestId + "' style='display: none;'>");
            this.write("<br/> ");
            this.writeDirectly(HtmlCounterRequestGraphReport.htmlEncodeRequestName(requestId, requestName));
            this.writeln("</div> ");
        }
    }

    private static void incrementUniqueByPageAndGraphSequence() {
        ++uniqueByPageAndGraphSequence;
    }

    private static String htmlEncodeRequestName(String requestId, String requestName) {
        return HtmlCounterReport.htmlEncodeRequestName(requestId, requestName);
    }

    void writeRequestAndGraphDetail(Collector collector, CollectorServer collectorServer, String graphName) throws IOException {
        this.counters = collector.getRangeCounters(this.range);
        this.requestsById = this.mapAllRequestsById();
        CounterRequest request = this.requestsById.get(graphName);
        if (request != null) {
            if (request.getRumData() != null && request.getRumData().getHits() > 0L) {
                this.writeRequestRumData(request);
            }
            this.writeRequest(request);
            if (JdbcWrapper.SINGLETON.getSqlCounter().isRequestIdFromThisCounter(graphName) && !request.getName().toLowerCase(Locale.ENGLISH).startsWith("alter ")) {
                this.writeSqlRequestExplainPlan(collector, collectorServer, request);
            }
        }
        if (this.isGraphDisplayed(collector, request)) {
            this.writeln("<table summary=''><tr><td>");
            this.writeln("<div id='track' class='noPrint'>");
            this.writeln("<div class='selected' id='handle'>");
            this.writeln("<img src='?resource=scaler_slider.gif' alt=''/>");
            this.writeln("</div></div>");
            this.writeln("</td><td>");
            this.writeDirectly("<div class='noPrint' style='color: #808080;'>");
            this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
            this.writeln("<label for='cb'><input id='cb' type='checkbox' onclick=\"handleHideMaximumClick(this);\"/>&nbsp;#hide_maximum#</label>");
            this.writeln("</div> ");
            this.writeln("</td></tr></table>");
            this.writeln("<div align='center'>");
            this.writeln("<table summary=''><tr><td>");
            this.writeln("<img class='synth\u00e8se' id='img' src='?width=960&amp;height=400&amp;graph=" + HtmlCounterRequestGraphReport.urlEncode(graphName) + "' alt='zoom'/>");
            this.writeDirectly("<br/><div align='right' style='color: #808080;'>");
            this.writeln("#graph_units#");
            this.writeln("</div></td></tr></table>");
            this.writeln("</div>");
            this.writeln("<div align='right'><a href='?part=lastValue&amp;graph=" + HtmlCounterRequestGraphReport.urlEncode(graphName) + "' title=\"#Lien_derniere_valeur#\">_</a></div>");
            this.writeGraphDetailScript(graphName);
        }
        if (request != null && request.getStackTrace() != null) {
            this.writeln("<blockquote><blockquote><b>Stack-trace</b><br/><font size='-1'>");
            this.writeStackTrace(request);
            this.writeln("</font></blockquote></blockquote>");
        }
    }

    private void writeStackTrace(CounterRequest request) throws IOException {
        for (String element : request.getStackTrace().split("[\n\r]")) {
            if (element.isEmpty()) continue;
            this.writeDirectly(HtmlSourceReport.htmlEncodeStackTraceElementAndTabs(element));
            this.writeDirectly("<br/>\n");
        }
    }

    private boolean isGraphDisplayed(Collector collector, CounterRequest request) throws IOException {
        return request == null || this.getCounterByRequestId(request) != null && HtmlCounterReport.isRequestGraphDisplayed(this.getCounterByRequestId(request)) && collector.getJRobin(request.getId()) != null;
    }

    private void writeSqlRequestExplainPlan(Collector collector, CollectorServer collectorServer, CounterRequest sqlRequest) throws IOException {
        try {
            String explainPlan = collectorServer == null ? DatabaseInformations.explainPlanFor(sqlRequest.getName()) : collectorServer.collectSqlRequestExplainPlan(collector.getApplication(), sqlRequest.getName());
            if (explainPlan != null) {
                this.writeln("<b>#Plan_d_execution#</b>");
                this.writeln("<div class='explainPlan'>");
                this.writeDirectly(explainPlan.replace(" ", "&nbsp;").replace("\n", "<br/>"));
                this.writeln("</div><hr/>");
            }
        }
        catch (Exception e) {
            this.writeln("<b>#Plan_d_execution#</b> ");
            this.writeln(e.toString());
            this.writeln("<br/>");
        }
    }

    void writeRequestUsages(Collector collector, String requestId) throws IOException {
        assert (requestId != null);
        this.counters = collector.getRangeCounters(this.range);
        CounterRequest myRequest = null;
        ArrayList<CounterRequest> requests = new ArrayList<CounterRequest>();
        for (Counter counter : this.counters) {
            for (CounterRequest request : counter.getOrderedRequests()) {
                if (myRequest == null && request.getId().equals(requestId)) {
                    myRequest = request;
                }
                if (!request.containsChildRequest(requestId)) continue;
                requests.add(request);
            }
        }
        this.writeRequestUsages(myRequest, requests);
    }

    private void writeRequestUsages(CounterRequest myRequest, List<CounterRequest> requests) throws IOException {
        this.writeln("<br/><b>#Utilisations_de#</b>");
        if (myRequest != null) {
            this.writeDirectly(HtmlCounterRequestGraphReport.htmlEncodeRequestName(myRequest.getId(), myRequest.getName()));
        }
        this.writeln("<br/><br/>");
        if (requests.isEmpty()) {
            this.writeln("#Aucune_requete#");
            return;
        }
        boolean someUsagesDisplayed = this.getUsagesDisplayed(requests);
        HtmlAbstractReport.HtmlTable table = new HtmlAbstractReport.HtmlTable();
        table.beginTable(HtmlCounterRequestGraphReport.getString("Utilisations_de"));
        this.write("<th>#Requete#</th>");
        if (someUsagesDisplayed) {
            this.write("<th class='noPrint'>#Chercher_utilisations#</th>");
        }
        for (CounterRequest request : requests) {
            table.nextRow();
            this.writeUsedRequest(request, someUsagesDisplayed);
        }
        table.endTable();
    }

    private void writeUsedRequest(CounterRequest request, boolean someUsageDisplayed) throws IOException {
        this.writeln(" <td>");
        this.writeCounterIcon(request);
        this.writeRequestGraph(request.getId(), request.getName());
        if (someUsageDisplayed) {
            this.writeln("</td><td align='center' class='noPrint'>");
            if (this.doesRequestDisplayUsages(request)) {
                this.writeln("<a href='?part=usages&amp;graph=" + request.getId() + "'>");
                this.writeln("<img src='?resource=find.png' alt='#Chercher_utilisations#' title='#Chercher_utilisations#'/></a>");
            } else {
                this.writeln("&nbsp;");
            }
        }
        this.writeln("</td>");
    }

    private boolean getUsagesDisplayed(List<CounterRequest> requests) {
        for (CounterRequest request : requests) {
            if (!this.doesRequestDisplayUsages(request)) continue;
            return true;
        }
        return false;
    }

    private void writeRequestRumData(CounterRequest request) throws IOException {
        CounterRequestRumData rumData = request.getRumData();
        DecimalFormat percentUsFormat = new DecimalFormat("0.00", DecimalFormatSymbols.getInstance(Locale.US));
        DecimalFormat percentLocaleFormat = I18N.createPercentFormat();
        int networkTimeMean = rumData.getNetworkTimeMean();
        int serverMean = request.getMean();
        int domProcessingMean = rumData.getDomProcessingMean();
        int pageRenderingMean = rumData.getPageRenderingMean();
        int total = networkTimeMean + serverMean + domProcessingMean + pageRenderingMean;
        double networkPercent = 100.0 * (double)networkTimeMean / (double)total;
        double serverPercent = 100.0 * (double)serverMean / (double)total;
        double domProcessingPercent = 100.0 * (double)domProcessingMean / (double)total;
        double pageRenderingPercent = 100.0 * (double)pageRenderingMean / (double)total;
        this.writeln("<br/><table class='rumData' summary=''><tr>");
        this.writeln("<td class='rumDataNetwork tooltip' style='width:" + percentUsFormat.format(networkPercent) + "%'><em>#Network#: " + this.integerFormat.format(networkTimeMean) + " ms (" + percentLocaleFormat.format(networkPercent) + "%)</em>#Network#</td>");
        this.writeln("<td class='rumDataServer tooltip' style='width:" + percentUsFormat.format(serverPercent) + "%'><em>#Server#: " + this.integerFormat.format(serverMean) + " ms (" + percentLocaleFormat.format(serverPercent) + "%)</em>#Server#</td>");
        this.writeln("<td class='rumDataDomProcessing tooltip' style='width:" + percentUsFormat.format(domProcessingPercent) + "%'><em>#DOM_processing#:" + this.integerFormat.format(domProcessingMean) + " ms (" + percentLocaleFormat.format(domProcessingPercent) + "%)</em>#DOM_processing#</td>");
        this.writeln("<td class='rumDataPageRendering tooltip' style='width:" + percentUsFormat.format(pageRenderingPercent) + "%'><em>#Page_rendering#:" + this.integerFormat.format(pageRenderingMean) + " ms (" + percentLocaleFormat.format(pageRenderingPercent) + "%)</em>#Page_rendering#</td>");
        this.writeln("</tr></table>");
    }

    private void writeRequest(CounterRequest request) throws IOException {
        boolean allChildHitsDisplayed;
        boolean allocatedKBytesDisplayed;
        boolean hasChildren;
        Map<String, Long> childRequests = request.getChildRequestsExecutionsByRequestId();
        this.writeln(" <br/>");
        HtmlAbstractReport.HtmlTable table = new HtmlAbstractReport.HtmlTable();
        table.beginTable(HtmlCounterRequestGraphReport.getString("Drill_down"));
        this.writeln("<th>#Requete#</th>");
        boolean bl = hasChildren = !childRequests.isEmpty();
        if (hasChildren) {
            this.writeln("<th class='sorttable_numeric'>#Hits_par_requete#</th>");
        }
        this.writeln("<th class='sorttable_numeric'>#Temps_moyen#</th><th class='sorttable_numeric'>#Temps_max#</th>");
        this.writeln("<th class='sorttable_numeric'>#Ecart_type#</th><th class='sorttable_numeric'>#Temps_cpu_moyen#</th>");
        boolean bl2 = allocatedKBytesDisplayed = request.getAllocatedKBytesMean() >= 0;
        if (allocatedKBytesDisplayed) {
            this.writeln("<th class='sorttable_numeric'>#Ko_alloues_moyens#</th>");
        }
        this.writeln("<th class='sorttable_numeric'>#erreur_systeme#</th>");
        Counter parentCounter = this.getCounterByRequestId(request);
        boolean bl3 = allChildHitsDisplayed = parentCounter != null && parentCounter.getChildCounterName() != null && request.hasChildHits();
        if (allChildHitsDisplayed) {
            String childCounterName = parentCounter.getChildCounterName();
            this.writeln("<th class='sorttable_numeric'>" + HtmlCounterRequestGraphReport.getFormattedString("hits_fils_moyens", childCounterName));
            this.writeln("</th><th class='sorttable_numeric'>" + HtmlCounterRequestGraphReport.getFormattedString("temps_fils_moyen", childCounterName) + "</th>");
        }
        table.nextRow();
        this.write("<td class='wrappedText'>");
        this.writeCounterIcon(request);
        this.writeDirectly(HtmlCounterRequestGraphReport.htmlEncodeRequestName(request.getId(), request.getName()));
        if (hasChildren) {
            this.writeln("</td><td>&nbsp;");
        }
        this.writeRequestValues(request, allChildHitsDisplayed, allocatedKBytesDisplayed);
        this.writeln("</td> ");
        if (hasChildren) {
            this.writeChildRequests(request, childRequests, allChildHitsDisplayed, allocatedKBytesDisplayed, table);
        }
        table.endTable();
        if (this.doesRequestDisplayUsages(request)) {
            this.writeln("<div align='right' class='noPrint'>");
            this.writeln("<a href='?part=usages&amp;graph=" + request.getId() + "'>");
            this.writeln("<img src='?resource=find.png' alt='#Chercher_utilisations#' ");
            this.writeln("title='#Chercher_utilisations#'/> #Chercher_utilisations#</a></div>");
        } else {
            this.writeln("<br/>");
        }
    }

    private boolean doesRequestDisplayUsages(CounterRequest request) {
        Counter parentCounter = this.getCounterByRequestId(request);
        return parentCounter != null && !parentCounter.isErrorCounter() && !"http".equals(parentCounter.getName());
    }

    private void writeChildRequests(CounterRequest request, Map<String, Long> childRequests, boolean allChildHitsDisplayed, boolean allocatedKBytesDisplayed, HtmlAbstractReport.HtmlTable table) throws IOException {
        for (Map.Entry<String, Long> entry : childRequests.entrySet()) {
            CounterRequest childRequest = this.requestsById.get(entry.getKey());
            if (childRequest == null) continue;
            table.nextRow();
            Long nbExecutions = entry.getValue();
            float executionsByRequest = (float)nbExecutions.longValue() / (float)request.getHits();
            this.writeChildRequest(childRequest, executionsByRequest, allChildHitsDisplayed, allocatedKBytesDisplayed);
        }
    }

    private void writeChildRequest(CounterRequest childRequest, float executionsByRequest, boolean allChildHitsDisplayed, boolean allocatedKBytesDisplayed) throws IOException {
        this.writeln("<td>");
        this.writeln("<div style='margin-left: 10px;' class='wrappedText'>");
        this.writeCounterIcon(childRequest);
        this.writeRequestGraph(childRequest.getId(), childRequest.getName());
        this.writeln("</div></td><td align='right'>");
        this.write(this.nbExecutionsFormat.format(executionsByRequest));
        this.writeRequestValues(childRequest, allChildHitsDisplayed, allocatedKBytesDisplayed);
        this.writeln("</td>");
    }

    private void writeRequestValues(CounterRequest request, boolean allChildHitsDisplayed, boolean allocatedKBytesDisplayed) throws IOException {
        String nextColumn = "</td><td align='right'>";
        this.writeln("</td><td align='right'>");
        this.writeln(this.integerFormat.format(request.getMean()));
        this.writeln("</td><td align='right'>");
        this.writeln(this.integerFormat.format(request.getMaximum()));
        this.writeln("</td><td align='right'>");
        this.writeln(this.integerFormat.format(request.getStandardDeviation()));
        this.writeln("</td><td align='right'>");
        String nbsp = "&nbsp;";
        if (request.getCpuTimeMean() >= 0) {
            this.writeln(this.integerFormat.format(request.getCpuTimeMean()));
        } else {
            this.writeln("&nbsp;");
        }
        if (allocatedKBytesDisplayed) {
            this.writeln("</td><td align='right'>");
            if (request.getAllocatedKBytesMean() >= 0) {
                this.writeln(this.integerFormat.format(request.getAllocatedKBytesMean()));
            } else {
                this.writeln("&nbsp;");
            }
        }
        this.writeln("</td><td align='right'>");
        this.writeln(this.systemErrorFormat.format(request.getSystemErrorPercentage()));
        if (allChildHitsDisplayed) {
            this.writeln("</td><td align='right'>");
            boolean childHitsDisplayed = request.hasChildHits();
            if (childHitsDisplayed) {
                this.writeln(this.integerFormat.format(request.getChildHitsMean()));
            } else {
                this.writeln("&nbsp;");
            }
            this.writeln("</td><td align='right'>");
            if (childHitsDisplayed) {
                this.writeln(this.integerFormat.format(request.getChildDurationsMean()));
            } else {
                this.writeln("&nbsp;");
            }
        }
    }

    private void writeCounterIcon(CounterRequest request) throws IOException {
        Counter parentCounter = this.getCounterByRequestId(request);
        if (parentCounter != null && parentCounter.getIconName() != null) {
            this.writeln("<img src='?resource=" + parentCounter.getIconName() + "' alt='" + parentCounter.getName() + "' width='16' height='16' />&nbsp;");
        }
    }

    private void writeGraphDetailScript(String graphName) throws IOException {
        this.writeln(SCRIPT_BEGIN);
        this.writeln("function handleHideMaximumClick(checkbox) {");
        this.writeln("    var img = document.getElementById('img');");
        this.writeln("    if (checkbox.checked) {");
        this.writeln("        img.src = img.src + '\\u0026max=false\\u0026r=' + Math.random();");
        this.writeln("    } else {");
        this.writeln("        img.src = img.src.replace('\\u0026max=false','');");
        this.writeln("    }");
        this.writeln("}");
        this.writeln("function scaleImage(v, min, max) {");
        this.writeln("    var images = document.getElementsByClassName('synth\u00e8se');");
        this.writeln("    w = (max - min) * v + min;");
        this.writeln("    for (i = 0; i < images.length; i++) {");
        this.writeln("        images[i].style.width = w + 'px';");
        this.writeln("    }");
        this.writeln("}");
        this.writeln("var slider = new Control.Slider('handle', 'track', {axis:'horizontal', alignX: 0, increment: 2});");
        this.writeln("slider.options.onSlide = function(value) {");
        this.writeln("  scaleImage(value, initialWidth, initialWidth / 2 * 3);");
        this.writeln("}");
        this.writeln("slider.options.onChange = function(value) {");
        this.writeln("  width = Math.round(Element.getStyle('img','width').replace('px','')) - 80;");
        this.writeln("  height = Math.round(width * initialHeight / initialWidth) - 48;");
        this.writeln("  document.getElementById('img').src = '?graph=" + HtmlCounterRequestGraphReport.htmlEncodeButNotSpace(HtmlCounterRequestGraphReport.urlEncode(graphName)) + "\\u0026width=' + width + '\\u0026height=' + height;");
        this.writeln("  document.getElementById('img').style.width = '';");
        this.writeln("}");
        this.writeln("window.onload = function() {");
        this.writeln("  if (navigator.appName == 'Microsoft Internet Explorer') {");
        this.writeln("    initialWidth = document.getElementById('img').width;");
        this.writeln("    initialHeight = document.getElementById('img').height;");
        this.writeln("  } else {");
        this.writeln("    initialWidth = Math.round(Element.getStyle('img','width').replace('px',''));");
        this.writeln("    initialHeight = Math.round(Element.getStyle('img','height').replace('px',''));");
        this.writeln("  }");
        this.writeln("}");
        this.writeln(SCRIPT_END);
    }

    private Map<String, CounterRequest> mapAllRequestsById() {
        HashMap<String, CounterRequest> result = new HashMap<String, CounterRequest>();
        for (Counter counter : this.counters) {
            for (CounterRequest request : counter.getRequests()) {
                result.put(request.getId(), request);
            }
        }
        return result;
    }

    private Counter getCounterByRequestId(CounterRequest request) {
        String requestId = request.getId();
        for (Counter counter : this.counters) {
            if (!counter.isRequestIdFromThisCounter(requestId)) continue;
            return counter;
        }
        return null;
    }
}

