/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.blobholder;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;

public abstract class AbstractBlobHolder
implements BlobHolder {
    @Override
    public abstract Blob getBlob() throws ClientException;

    @Override
    public void setBlob(Blob blob) throws ClientException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Blob> getBlobs() throws ClientException {
        ArrayList<Blob> blobs = null;
        Blob blob = this.getBlob();
        if (blob != null) {
            blobs = new ArrayList<Blob>();
            blobs.add(blob);
        }
        return blobs;
    }

    protected abstract String getBasePath();

    @Override
    public String getFilePath() throws ClientException {
        String path = this.getBasePath();
        Blob blob = this.getBlob();
        if (blob != null) {
            path = path + "/" + blob.getFilename();
        }
        return path;
    }

    @Override
    public String getHash() throws ClientException {
        Blob blob = this.getBlob();
        if (blob != null) {
            String h = blob.getDigest();
            if (h == null) {
                h = this.getMD5Digest();
                blob.setDigest(h);
            }
            return h;
        }
        return "NullBlob";
    }

    protected String getMD5Digest() throws ClientException {
        String string;
        InputStream in = null;
        try {
            Blob blob = this.getBlob().persist();
            in = blob.getStream();
            string = DigestUtils.md5Hex((InputStream)in);
        }
        catch (IOException e) {
            try {
                throw new ClientException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)in);
        return string;
    }

    @Override
    public abstract Calendar getModificationDate() throws ClientException;
}

