/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.thumbnail;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.blobholder.BlobHolderAdapterComponent;
import org.nuxeo.ecm.core.api.thumbnail.ThumbnailFactory;
import org.nuxeo.ecm.core.api.thumbnail.ThumbnailFactoryDescriptor;
import org.nuxeo.ecm.core.api.thumbnail.ThumbnailService;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class ThumbnailServiceImpl
extends DefaultComponent
implements ThumbnailService {
    private static final Log log = LogFactory.getLog(BlobHolderAdapterComponent.class);
    public static final String THUMBNAILFACTORY_EP = "thumbnailFactory";
    protected static ThumbnailFactory defaultFactory;
    protected static final Map<String, ThumbnailFactory> factoriesByDocType;
    protected static final Map<String, ThumbnailFactory> factoriesByFacets;

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (THUMBNAILFACTORY_EP.equals(extensionPoint)) {
            String facet;
            ThumbnailFactoryDescriptor desc = (ThumbnailFactoryDescriptor)contribution;
            String docType = desc.getDocType();
            if (docType != null) {
                factoriesByDocType.put(docType, desc.getFactory());
            }
            if ((facet = desc.getFacet()) != null) {
                factoriesByFacets.put(facet, desc.getFactory());
            }
            if (docType == null && facet == null) {
                defaultFactory = desc.getFactory();
            }
        } else {
            log.error((Object)("Unknown extension point " + extensionPoint));
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
    }

    public Set<String> getFactoryByDocTypeNames() {
        return factoriesByDocType.keySet();
    }

    public Set<String> getFactoryByFacetNames() {
        return factoriesByFacets.keySet();
    }

    public ThumbnailFactory getDefaultFactory() {
        return defaultFactory;
    }

    @Override
    public Blob getThumbnail(DocumentModel doc, CoreSession session) throws ClientException {
        ThumbnailFactory factory = this.getThumbnailFactory(doc, session);
        return factory.getThumbnail(doc, session);
    }

    @Override
    public Blob computeThumbnail(DocumentModel doc, CoreSession session) throws ClientException {
        ThumbnailFactory factory = this.getThumbnailFactory(doc, session);
        return factory.computeThumbnail(doc, session);
    }

    public ThumbnailFactory getThumbnailFactory(DocumentModel doc, CoreSession session) throws ClientException {
        if (factoriesByDocType.containsKey(doc.getType())) {
            ThumbnailFactory factory = factoriesByDocType.get(doc.getType());
            return factory;
        }
        for (Map.Entry<String, ThumbnailFactory> entry : factoriesByFacets.entrySet()) {
            if (!doc.hasFacet(entry.getKey())) continue;
            return entry.getValue();
        }
        if (defaultFactory == null) {
            throw new ClientException("Please contribute a default thumbnail factory");
        }
        return defaultFactory;
    }

    static {
        factoriesByDocType = new HashMap<String, ThumbnailFactory>();
        factoriesByFacets = new HashMap<String, ThumbnailFactory>();
    }
}

