/*
 * Decompiled with CFR 0.152.
 */
package org.opentoutatice.core.type.enricher;

import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.schema.DocumentTypeDescriptor;
import org.nuxeo.ecm.core.schema.TypeService;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.Extension;
import org.opentoutatice.core.type.enricher.ExclusionRulesDescriptor;
import org.opentoutatice.core.type.enricher.SchemaManagerEnricher;

public class EnricherTypeService
extends TypeService {
    private static final Log log = LogFactory.getLog(EnricherTypeService.class);
    public static final String BASE_TYPE_EXT_POINT = "basettc";
    public static final String EXCLUDED_RULES_EXT_POINT = "excludedRules";
    private SchemaManagerEnricher schemaManagerEnricher;
    private DocumentTypeDescriptor baseDocTypeDescriptor;
    private ExclusionRulesDescriptor rulesDescriptor;

    public void activate(ComponentContext context) {
        super.activate(context);
        this.schemaManagerEnricher = new SchemaManagerEnricher();
    }

    public void registerExtension(Extension extension) {
        super.registerExtension(extension);
        String extensionPoint = extension.getExtensionPoint();
        if (BASE_TYPE_EXT_POINT.equals(extensionPoint)) {
            Object[] contribs;
            for (Object contrib : contribs = extension.getContributions()) {
                if (this.baseDocTypeDescriptor == null) {
                    this.baseDocTypeDescriptor = (DocumentTypeDescriptor)contrib;
                } else {
                    this.baseDocTypeDescriptor.merge((DocumentTypeDescriptor)contrib);
                }
                if (this.baseDocTypeDescriptor == null) continue;
                this.schemaManagerEnricher.setBaseDocTypeDescriptor(this.baseDocTypeDescriptor);
            }
        }
        if (EXCLUDED_RULES_EXT_POINT.equals(extensionPoint)) {
            Object contrib = extension.getContributions()[0];
            if (this.rulesDescriptor == null) {
                this.rulesDescriptor = (ExclusionRulesDescriptor)contrib;
                this.schemaManagerEnricher.setExcludedTypes(Arrays.asList(this.rulesDescriptor.getTypes()));
                this.schemaManagerEnricher.setFacetsExcludingTypes(Arrays.asList(this.rulesDescriptor.getFacets()));
            }
        }
    }

    public void applicationStarted(ComponentContext context) throws Exception {
        long begin = System.currentTimeMillis();
        if (log.isInfoEnabled()) {
            log.info((Object)"Enriching doctypes setting toutatice schema ...");
        }
        this.schemaManagerEnricher.enrichTypes();
        super.applicationStarted(context);
        if (log.isDebugEnabled()) {
            long end = System.currentTimeMillis();
            log.debug((Object)("enrichTypes + flushPendingsRegistration: " + String.valueOf(end - begin) + " ms"));
        }
        if (log.isInfoEnabled()) {
            log.info((Object)"Doctypes enriched with toutatice schema.");
        }
    }

    public void deactivate(ComponentContext context) {
        super.deactivate(context);
        this.schemaManagerEnricher = null;
    }
}

