/*
 * Decompiled with CFR 0.152.
 */
package org.opentoutatice.core.type.enricher;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.schema.DocumentTypeDescriptor;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.runtime.api.Framework;
import org.opentoutatice.core.type.enricher.EnricherTypeException;

public class SchemaManagerEnricher {
    private static final Log log = LogFactory.getLog(SchemaManagerEnricher.class);
    private SchemaManager schemaManager;
    private DocumentTypeDescriptor baseDocTypeDescriptor;
    protected List<String> excludedTypes = new ArrayList<String>();
    protected List<String> facetsExcludingTypes = new ArrayList<String>();

    public SchemaManager getSchemaManager() {
        if (this.schemaManager == null) {
            this.schemaManager = (SchemaManager)Framework.getService(SchemaManager.class);
        }
        return this.schemaManager;
    }

    public DocumentTypeDescriptor getBaseDocTypeDescriptor() {
        return this.baseDocTypeDescriptor;
    }

    public void setBaseDocTypeDescriptor(DocumentTypeDescriptor baseDocTypeDescriptor) {
        this.baseDocTypeDescriptor = baseDocTypeDescriptor;
    }

    public List<String> getExcludedTypes() {
        return this.excludedTypes;
    }

    public void setExcludedTypes(List<String> excludedTypes) {
        this.excludedTypes = excludedTypes;
    }

    public List<String> getFacetsExcludingTypes() {
        return this.facetsExcludingTypes;
    }

    public void setFacetsExcludingTypes(List<String> facetsExcludingTypes) {
        this.facetsExcludingTypes = facetsExcludingTypes;
    }

    public void enrichTypes() {
        long begin = System.currentTimeMillis();
        ListIterator<DocumentTypeDescriptor> allListIt = this.getAllRegisteredDocumentTypes().listIterator();
        while (allListIt.hasNext()) {
            DocumentTypeDescriptor typeDescriptor = allListIt.next();
            boolean toExcludeFromEnriching = this.excludedTypes.contains(typeDescriptor.name);
            if (typeDescriptor.facets != null) {
                toExcludeFromEnriching |= CollectionUtils.containsAny(Arrays.asList(typeDescriptor.facets), this.facetsExcludingTypes);
            }
            if (toExcludeFromEnriching) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Not enriched: " + typeDescriptor.name));
                continue;
            }
            allListIt.set(typeDescriptor.merge(this.baseDocTypeDescriptor));
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Enriched: " + typeDescriptor.name));
        }
        if (log.isDebugEnabled()) {
            long part = System.currentTimeMillis();
            log.debug((Object)("#enrichTypes: " + String.valueOf(part - begin) + " ms"));
        }
    }

    protected List<DocumentTypeDescriptor> getAllRegisteredDocumentTypes() {
        List dtds = null;
        try {
            dtds = (List)this.getAllDocumentTypes().get(this.getSchemaManager());
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new EnricherTypeException("Unable to get enriched types: ", e);
        }
        return dtds;
    }

    protected void setAllRegisteredDocumentTypes(List<DocumentTypeDescriptor> enrichedTypes) {
        try {
            Field docTypesField = this.getAllDocumentTypes();
            docTypesField.set(this.getSchemaManager(), enrichedTypes);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new EnricherTypeException("Unable to register enriched types: ", e);
        }
    }

    private Field getAllDocumentTypes() throws NoSuchFieldException {
        Field docTypesField = this.getSchemaManager().getClass().getDeclaredField("allDocumentTypes");
        docTypesField.setAccessible(true);
        return docTypesField;
    }
}

