/*
 * Decompiled with CFR 0.152.
 */
package org.restlet;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.restlet.Context;
import org.restlet.Restlet;
import org.restlet.Route;
import org.restlet.Router;
import org.restlet.data.Request;
import org.restlet.data.Response;

public class VirtualHost
extends Router {
    private String name;
    private String hostDomain;
    private String hostPort;
    private String hostScheme;
    private String resourceDomain;
    private String resourcePort;
    private String resourceScheme;
    private String serverAddress;
    private String serverPort;

    public static String getIpAddress(String domain) {
        String result = null;
        try {
            result = InetAddress.getByName(domain).getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return result;
    }

    public static String getLocalHostAddress() {
        String result = null;
        try {
            result = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return result;
    }

    public static String getLocalHostName() {
        String result = null;
        try {
            result = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return result;
    }

    public VirtualHost() {
        this(null);
    }

    public VirtualHost(Context context) {
        this(context, ".*", ".*", ".*", ".*", ".*", ".*", ".*", ".*");
    }

    public VirtualHost(Context context, String hostDomain, String hostPort, String hostScheme, String resourceDomain, String resourcePort, String resourceScheme, String serverAddress, String serverPort) {
        super(context);
        this.hostDomain = hostDomain;
        this.hostPort = hostPort;
        this.hostScheme = hostScheme;
        this.resourceDomain = resourceDomain;
        this.resourcePort = resourcePort;
        this.resourceScheme = resourceScheme;
        this.serverAddress = serverAddress;
        this.serverPort = serverPort;
    }

    protected Route createRoute(String uriPattern, Restlet target) {
        return new Route(this, uriPattern, target){

            protected void beforeHandle(Request request, Response response) {
                super.beforeHandle(request, response);
                request.setRootRef(request.getResourceRef().getBaseRef());
            }
        };
    }

    public String getHostDomain() {
        return this.hostDomain;
    }

    public String getHostPort() {
        return this.hostPort;
    }

    public String getHostScheme() {
        return this.hostScheme;
    }

    public String getName() {
        return this.name;
    }

    public String getResourceDomain() {
        return this.resourceDomain;
    }

    public String getResourcePort() {
        return this.resourcePort;
    }

    public String getResourceScheme() {
        return this.resourceScheme;
    }

    public String getServerAddress() {
        return this.serverAddress;
    }

    public String getServerPort() {
        return this.serverPort;
    }

    public void setHostDomain(String hostDomain) {
        this.hostDomain = hostDomain;
    }

    public void setHostPort(String hostPort) {
        this.hostPort = hostPort;
    }

    public void setHostScheme(String hostScheme) {
        this.hostScheme = hostScheme;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setResourceDomain(String resourceDomain) {
        this.resourceDomain = resourceDomain;
    }

    public void setResourcePort(String resourcePort) {
        this.resourcePort = resourcePort;
    }

    public void setResourceScheme(String resourceScheme) {
        this.resourceScheme = resourceScheme;
    }

    public void setServerAddress(String serverAddress) {
        this.serverAddress = serverAddress;
    }

    public void setServerPort(String serverPort) {
        this.serverPort = serverPort;
    }
}

