/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.api;

public class LambdaAdaptor {

    public static class Optional<T> {
        static final Optional<?> empty = new Optional();
        final T value;

        static <T> Optional<T> of(T value) {
            return new Optional<T>(value);
        }

        static <T> Optional<T> empty() {
            return empty;
        }

        static <T> Optional<T> ofNullable(T value) {
            return value == null ? Optional.empty() : Optional.of(value);
        }

        Optional() {
            this.value = null;
        }

        Optional(T value) {
            this.value = value;
        }

        <R> Optional<R> map(Function<T, R> function) {
            return this.value == null ? Optional.empty() : Optional.of(function.apply(this.value));
        }

        T orElseGet(Supplier<T> supplier) {
            return this.value != null ? this.value : supplier.get();
        }

        T orElse(T otherValue) {
            return this.value != null ? this.value : otherValue;
        }

        void ifPresent(Consumer<T> consumer) {
            if (this.value != null) {
                consumer.accept(this.value);
            }
        }

        boolean isPresent() {
            return this.value != null;
        }
    }

    public static interface Function<T, R> {
        public R apply(T var1);
    }

    public static interface Supplier<T> {
        public T get();
    }

    public static interface Consumer<T> {
        public void accept(T var1);
    }

    public static interface RunnableCheckException<X extends Exception> {
        public void run() throws X;
    }
}

