/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.services.streaming;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.nuxeo.runtime.services.streaming.AbstractStreamSource;

public class ZipEntrySource
extends AbstractStreamSource {
    protected final String file;
    protected final String entry;

    public ZipEntrySource(String file, String entry) {
        this.file = file;
        this.entry = entry;
    }

    public ZipEntrySource(File file, String entry) {
        this.file = file.getAbsolutePath();
        this.entry = entry;
    }

    @Override
    public InputStream getStream() throws IOException {
        ZipFile zf = new ZipFile(this.file);
        ZipEntry zentry = zf.getEntry(this.entry);
        if (zentry == null) {
            return null;
        }
        return new ZipEntryInputStream(zf, zf.getInputStream(zentry));
    }

    @Override
    public boolean canReopen() {
        return true;
    }

    @Override
    public long getLength() throws IOException {
        return -1L;
    }

    class ZipEntryInputStream
    extends InputStream {
        final InputStream in;
        final ZipFile zip;

        ZipEntryInputStream(ZipFile zip, InputStream in) {
            this.in = in;
            this.zip = zip;
        }

        @Override
        public int available() throws IOException {
            return this.in.available();
        }

        @Override
        public void close() throws IOException {
            try {
                this.in.close();
            }
            finally {
                this.zip.close();
            }
        }

        @Override
        public synchronized void mark(int readlimit) {
            this.in.mark(readlimit);
        }

        @Override
        public boolean markSupported() {
            return this.in.markSupported();
        }

        @Override
        public int read() throws IOException {
            return this.in.read();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.in.read(b, off, len);
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.in.read(b);
        }

        @Override
        public synchronized void reset() throws IOException {
            this.in.reset();
        }

        @Override
        public long skip(long n) throws IOException {
            return this.in.skip(n);
        }
    }
}

