/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.acrennes.web.document;

import fr.toutatice.ecm.acrennes.core.constants.AcrennesConstants;
import fr.toutatice.ecm.platform.core.helper.ToutaticeDirectoryMngtHelper;
import fr.toutatice.ecm.platform.core.helper.ToutaticeNotifyEventHelper;
import fr.toutatice.ecm.platform.document.ToutaticeRPDocumentActionsBean;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.annotation.security.PermitAll;
import javax.ejb.PostActivate;
import javax.ejb.PrePassivate;
import javax.ejb.Remove;
import javax.faces.context.FacesContext;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Destroy;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.international.StatusMessage;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;

@Name(value="documentActions")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=56)
public class AcrennesDocumentActionsBean
extends ToutaticeRPDocumentActionsBean {
    private static final long serialVersionUID = 6185425294231836912L;
    private static final Log log = LogFactory.getLog(AcrennesDocumentActionsBean.class);
    private List<String> dageDocTypesList;
    private String newSubject;

    @Create
    public void initialize() throws Exception {
        log.debug((Object)"Initializing...");
        this.dageDocTypesList = Arrays.asList(AcrennesConstants.CST_DOC_TYPE_DAGE_LIST);
    }

    @Destroy
    @Remove
    @PermitAll
    public void destroy() {
        log.debug((Object)"Removing SEAM action listener...");
    }

    @PrePassivate
    public void saveState() {
        log.debug((Object)"PrePassivate");
    }

    @PostActivate
    public void readState() {
        log.debug((Object)"PostActivate");
    }

    public String saveDocument() throws ClientException {
        DocumentModel changeableDocument = this.navigationContext.getChangeableDocument();
        try {
            String view = super.saveDocument();
            if (this.dageDocTypesList.contains(changeableDocument.getType())) {
                this.facesMessages.clear();
                this.facesMessages.add(StatusMessage.Severity.INFO, (String)this.resourcesAccessor.getMessages().get("label.acaren.faces.dage.document.created"), new Object[0]);
            }
            return view;
        }
        catch (Throwable t) {
            return this.navigationContext.navigateToDocument(this.navigationContext.getCurrentDocument(), "after-create");
        }
    }

    public String saveNSetOnLineDocument() throws ClientException {
        DocumentModel changeableDocument = this.navigationContext.getChangeableDocument();
        String view = super.saveNSetOnLineDocument();
        if (this.dageDocTypesList.contains(changeableDocument.getType())) {
            this.facesMessages.clear();
            this.facesMessages.add(StatusMessage.Severity.INFO, (String)this.resourcesAccessor.getMessages().get("label.acaren.faces.dage.document.created"), new Object[0]);
        }
        return view;
    }

    public boolean canBePublishedInPortal() {
        return this.belongToPublishSpace();
    }

    public void propageSourceOrganisationnelle() {
        try {
            DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
            if (null != currentDocument) {
                String srcOrg = (String)((Object)currentDocument.getPropertyValue("acr:publisher"));
                String orgDC = (String)((Object)currentDocument.getPropertyValue("dc:publisher"));
                if (StringUtils.isNotBlank((String)srcOrg) || StringUtils.isNotBlank((String)orgDC)) {
                    HashMap<String, String> properties = new HashMap<String, String>();
                    properties.put("source", srcOrg);
                    properties.put("organization", orgDC);
                    ToutaticeNotifyEventHelper.notifyEvent((CoreSession)this.documentManager, (String)"propagateOrganisationSource", (DocumentModel)currentDocument, properties);
                    this.facesMessages.add(StatusMessage.Severity.INFO, "Le processus de propagation a d\u00e9marr\u00e9.", new Object[0]);
                    String srcOrgLabel = ToutaticeDirectoryMngtHelper.instance().getDirectoryEntriesLocalizedLabel(AcrennesConstants.CST_VOCABULARY_ORGANISATION_SOURCES, srcOrg, Locale.FRENCH);
                    log.info((Object)("D\u00e9marrage du processus de propagation de la source '" + srcOrgLabel + "' sur le document '" + currentDocument.getName() + "'"));
                }
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed to launch the process to propagate the organisation source, error: " + e.getMessage()));
        }
    }

    public String addDocumentSubject() throws ClientException {
        if (this.newSubject == null || "".equals(this.newSubject)) {
            return null;
        }
        DocumentModel currentDoc = this.getCurrentDocument();
        if (currentDoc != null) {
            List<Object> subjects;
            Object subjectsObj = currentDoc.getProperty("dublincore", "subjects");
            if (subjectsObj != null) {
                if (subjectsObj instanceof List) {
                    subjects = (List)subjectsObj;
                } else {
                    String[] subjectsArray = (String[])subjectsObj;
                    subjects = Arrays.asList(subjectsArray);
                    subjects = new ArrayList(subjects);
                }
            } else {
                subjects = new ArrayList();
            }
            if (this.newSubject.contains("  ")) {
                this.newSubject = this.newSubject.replaceAll("  ", " ");
            }
            if (this.newSubject.contains(", ") || this.newSubject.contains(" ,")) {
                this.newSubject = this.newSubject.replaceAll(", ", ",");
                this.newSubject = this.newSubject.replaceAll(" ,", ",");
            }
            String[] s = this.newSubject.split(",");
            for (int i = 0; i < s.length; ++i) {
                subjects.add(s[i]);
            }
            this.newSubject = "";
            currentDoc.setProperty("dublincore", "subjects", subjects);
        }
        return null;
    }

    public String removeDocumentSubject() throws ClientException {
        DocumentModel currentDoc = this.getCurrentDocument();
        if (currentDoc != null) {
            List<String> subjects;
            Object subjectsObj = currentDoc.getProperty("dublincore", "subjects");
            if (subjectsObj instanceof List) {
                subjects = (List<String>)subjectsObj;
            } else {
                String[] subjectsArray = (String[])subjectsObj;
                subjects = Arrays.asList(subjectsArray);
                subjects = new ArrayList<String>(subjects);
            }
            FacesContext context = FacesContext.getCurrentInstance();
            String subject = (String)context.getExternalContext().getRequestParameterMap().get("subject");
            subjects.remove(subject);
            currentDoc.setProperty("dublincore", "subjects", subjects);
        }
        return null;
    }

    public String getNewSubject() {
        return this.newSubject;
    }

    public void setNewSubject(String newSubject) {
        this.newSubject = newSubject;
    }

    @Observer(value={"changeableDocumentCreated"})
    public void initShowInMenu() throws ClientException {
        super.initShowInMenu();
        DocumentModel newDocument = this.navigationContext.getChangeableDocument();
        if (newDocument.hasFacet("TTCPublishSpace")) {
            newDocument.setPropertyValue("ttcs:spaceCommentable", (Serializable)Boolean.valueOf(false));
        }
    }

    public String createWebPageUrl() throws ClientException {
        String url = null;
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        if (currentDocument.hasSchema("webpage")) {
            DocumentModel parent = this.documentManager.getSuperSpace(currentDocument);
            String urlBase = parent.getDataModel("webcontainer").getData("url").toString();
            String currentDocumentPath = currentDocument.getPathAsString();
            String urlPath = currentDocumentPath.substring(currentDocumentPath.indexOf(parent.getName()), currentDocumentPath.length());
            url = urlBase.replace(parent.getName(), urlPath);
        }
        log.debug((Object)(currentDocument.getName() + "\t a pour Url\t" + url));
        return url;
    }
}

