/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.acrennes.web.document;

import fr.toutatice.ecm.platform.core.helper.ToutaticeUserMngtHelper;
import fr.toutatice.ecm.platform.web.document.ToutaticeSecurityActionsBean;
import java.security.Principal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;

@Name(value="securityActions")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=56)
public class AcrennesSecurityActionsBean
extends ToutaticeSecurityActionsBean {
    private static final long serialVersionUID = 1L;
    private Map<String, Boolean> publicUsersMap = new HashMap<String, Boolean>();
    private static List<String> PUBLIC_USERS = null;
    private static String NX_GROUP_NAME = "Administrators";

    private void checkACLForUsername(ACL acl, String userName) {
        if (null != acl) {
            ACE[] aces = acl.getACEs();
            for (int i = 0; i < aces.length; ++i) {
                if (!"Read".equals(aces[i].getPermission()) && !"Write".equals(aces[i].getPermission()) || !userName.equals(aces[i].getUsername())) continue;
                this.publicUsersMap.put(userName, aces[i].isGranted());
            }
        }
    }

    public boolean isVisibleFromLargePublic() throws ClientException {
        boolean status = true;
        DocumentModel doc = this.navigationContext.getCurrentDocument();
        ACP acp = doc.getACP();
        this.publicUsersMap.clear();
        ACL acl = acp.getACL("inherited");
        for (String userName : this.getPublicUsers()) {
            this.checkACLForUsername(acl, userName);
        }
        for (String userName : this.getPublicUsers()) {
            acl = acp.getACL("local");
            this.checkACLForUsername(acl, userName);
        }
        for (String userName : this.getPublicUsers()) {
            if (null == this.userManager.getGroup(userName) && null == this.userManager.getUserModel(userName) || this.publicUsersMap.containsKey(userName) && this.publicUsersMap.get(userName).booleanValue()) continue;
            status = false;
        }
        return status;
    }

    public void setVisibleFromLargePublic() throws ClientException {
        for (String userName : this.getPublicUsers()) {
            this.addPermission(userName, "Read", true);
        }
    }

    public void setNotVisibleFromLargePublic() throws ClientException {
        for (String userName : this.getPublicUsers()) {
            this.securityData.removeModifiablePrivilege(userName, "Read", true);
        }
    }

    private List<String> getPublicUsers() throws ClientException {
        if (null == PUBLIC_USERS) {
            PUBLIC_USERS = ToutaticeUserMngtHelper.instance().getPublicUsers();
        }
        return PUBLIC_USERS;
    }

    public String blockRightInheritance() throws ClientException {
        boolean doAddCurrentUSer = true;
        Boolean blockRightInheritance = this.getBlockRightInheritance();
        this.rebuildSecurityData();
        if (blockRightInheritance.booleanValue()) {
            this.getSecurityData().addModifiablePrivilege("Everyone", "Everything", false);
            Principal currentUser = FacesContext.getCurrentInstance().getExternalContext().getUserPrincipal();
            if (this.getSecurityData().getCurrentDocumentUsers() != null && !this.getSecurityData().getCurrentDocumentUsers().contains(currentUser.getName())) {
                List adminGroups = this.userManager.getAdministratorsGroups();
                DocumentModel nxGrp = this.userManager.getGroupModel(NX_GROUP_NAME);
                if (null != nxGrp) {
                    adminGroups.add(NX_GROUP_NAME);
                    for (String adminGroup : adminGroups) {
                        this.getSecurityData().addModifiablePrivilege(adminGroup, "Everything", true);
                        List usersList = this.userManager.getUsersInGroup(NX_GROUP_NAME);
                        if (null == usersList || !usersList.contains(currentUser.getName())) continue;
                        doAddCurrentUSer = false;
                    }
                }
                if (doAddCurrentUSer) {
                    this.getSecurityData().addModifiablePrivilege(currentUser.getName(), "Everything", true);
                }
            }
        } else {
            this.getSecurityData().removeModifiablePrivilege("Everyone", "Everything", false);
        }
        this.updateSecurityOnDocument();
        this.resetSecurityData();
        this.setSelectedEntries(null);
        return null;
    }
}

