/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.acrennes.web.publication;

import fr.toutatice.ecm.acrennes.web.publication.AcrennesPublishDate;
import fr.toutatice.ecm.platform.core.helper.ToutaticeDocumentHelper;
import fr.toutatice.ecm.platform.core.helper.ToutaticeSilentProcessRunnerHelper;
import java.io.Serializable;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.core.Events;
import org.jboss.seam.faces.FacesMessages;
import org.jboss.seam.international.StatusMessage;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.webapp.helpers.ResourcesAccessor;

@Name(value="acarenPublishDate")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=56)
public class AcrennesPublishDateBean
implements AcrennesPublishDate,
Serializable {
    private static final long serialVersionUID = 4754534201109265382L;
    private static final Log log = LogFactory.getLog(AcrennesPublishDateBean.class);
    private Date date = null;
    @In(create=true)
    protected transient NavigationContext navigationContext;
    @In(create=true)
    protected transient CoreSession documentManager;
    @In(create=true, required=false)
    protected FacesMessages facesMessages;
    @In(create=true)
    protected ResourcesAccessor resourcesAccessor;

    @Override
    public Date getDate() {
        if (null == this.date) {
            try {
                DocumentModel currentDoc = this.navigationContext.getCurrentDocument();
                GetIssuedDateRunner runner = new GetIssuedDateRunner(this.documentManager, currentDoc);
                runner.runUnrestricted();
                this.date = runner.getDate();
            }
            catch (ClientException e) {
                log.error((Object)("Failed to get the publication date of the document, error: " + e.getMessage()));
            }
        }
        return this.date;
    }

    @Override
    public void setDate(Date date) {
        this.date = date;
    }

    @Override
    public String updateDocumentDate() {
        try {
            if (this.date != null) {
                DocumentModel currentDoc = this.navigationContext.getCurrentDocument();
                UpdateIssuedDateRunner runner = new UpdateIssuedDateRunner(this.documentManager, currentDoc, this.date);
                runner.silentRun(true);
                this.date = null;
            }
        }
        catch (ClientException e) {
            log.error((Object)("Failed to update the publication date of the document, error: " + e.getMessage()));
        }
        this.facesMessages.add(StatusMessage.Severity.INFO, (String)this.resourcesAccessor.getMessages().get("acaren.action.edit.publication.date.saved"), new Object[0]);
        Events.instance().raiseEvent("documentChanged", new Object[0]);
        return "view_documents";
    }

    @Override
    public String cancel() {
        this.date = null;
        return "view_documents";
    }

    private class UpdateIssuedDateRunner
    extends ToutaticeSilentProcessRunnerHelper {
        private DocumentModel doc;
        private Date date;

        public UpdateIssuedDateRunner(CoreSession session, DocumentModel doc, Date date) {
            super(session);
            this.doc = doc;
            this.date = date;
        }

        public void run() throws ClientException {
            DocumentModel proxy = ToutaticeDocumentHelper.getProxy((CoreSession)this.session, (DocumentModel)this.doc, null);
            if (null != proxy) {
                String srcDocId = proxy.getSourceId();
                DocumentModel srcDoc = this.session.getDocument((DocumentRef)new IdRef(srcDocId));
                srcDoc.setPropertyValue("dc:issued", (Serializable)this.date);
                this.session.saveDocument(srcDoc);
            }
        }
    }

    private class GetIssuedDateRunner
    extends UnrestrictedSessionRunner {
        private DocumentModel doc;
        private Date date;

        public GetIssuedDateRunner(CoreSession session, DocumentModel doc) {
            super(session);
            this.doc = doc;
            this.date = null;
        }

        public Date getDate() {
            return this.date;
        }

        public void run() throws ClientException {
            String srcDocId;
            DocumentModel srcDoc;
            GregorianCalendar gDate;
            DocumentModel proxy = ToutaticeDocumentHelper.getProxy((CoreSession)this.session, (DocumentModel)this.doc, null);
            if (null != proxy && null != (gDate = (GregorianCalendar)(srcDoc = this.session.getDocument((DocumentRef)new IdRef(srcDocId = proxy.getSourceId()))).getPropertyValue("dc:issued"))) {
                this.date = gDate.getTime();
            }
        }
    }
}

