/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.acrennes.web.userservices;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.ValidatorException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.platform.ui.web.util.ComponentUtils;

@Name(value="acrennesWidgetValidator")
@Scope(value=ScopeType.SESSION)
@Install(precedence=56)
public class AcrennesValidatorBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(AcrennesValidatorBean.class);
    private static final String CST_PATTERN_URL = "^(((http|ftp)[s]{0,1}://)|(mailto:[a-zA-Z0-9])).*";
    private static final String CST_PATTERN_EMAIL = "^[_A-Za-z0-9-]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9]+([\\.-]+[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$";
    private static final String CST_PATTERN_TEL = "^[0-9]{2}([- ]?[0-9]{2}){4}$";
    private static final String CST_PATTERN_RNE = "^[0-9]{7}([ ]?)[a-zA-Z]{1}$";
    private static final String CST_PATTERN_ISBN = "^(?=.{13}$)(([0-9]{1,5})-[0-9]{1,7}-[0-9]{1,6}-[0-9,x,X]{1})|(?=.{17}$)([0-9]{3}-[0-9]{1,5})-[0-9]{1,7}-[0-9]{1,6}-[0-9]{1}$";
    private static final String CST_PATTERN_GPS_POSITION = "^[-\\+]?\\d{1,2}(\\.\\d+)$";

    public void validateUrl(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        String url = (String)value;
        if (StringUtils.isNotBlank((String)url)) {
            try {
                Pattern p = Pattern.compile(CST_PATTERN_URL);
                Matcher m = p.matcher(url);
                if (!m.matches()) {
                    String msg = ComponentUtils.translate((FacesContext)context, (String)"label.acaren.validator.bad.url.format");
                    FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_ERROR, msg, null);
                    throw new ValidatorException(message);
                }
            }
            catch (PatternSyntaxException pse) {
                log.error((Object)pse.getMessage());
            }
        }
    }

    public void validateGpsPosition(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        String gpsPosition = (String)value;
        if (StringUtils.isNotBlank((String)gpsPosition)) {
            try {
                Pattern p = Pattern.compile(CST_PATTERN_GPS_POSITION);
                Matcher m = p.matcher(gpsPosition);
                if (!m.matches()) {
                    String msg = ComponentUtils.translate((FacesContext)context, (String)"label.acaren.validator.bad.gps.format");
                    FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_ERROR, msg, null);
                    throw new ValidatorException(message);
                }
            }
            catch (PatternSyntaxException pse) {
                log.error((Object)pse.getMessage());
            }
        }
    }

    public void validateEmail(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        String emails = (String)value;
        if (StringUtils.isNotBlank((String)emails)) {
            String[] tabEmails = emails.split(",");
            try {
                if (tabEmails != null && tabEmails.length > 0) {
                    for (String email : tabEmails) {
                        Pattern p = Pattern.compile(CST_PATTERN_EMAIL);
                        Matcher m = p.matcher(email);
                        if (m.matches()) continue;
                        String msg = ComponentUtils.translate((FacesContext)context, (String)"label.acaren.validator.bad.email.format");
                        FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_ERROR, msg, null);
                        throw new ValidatorException(message);
                    }
                }
            }
            catch (PatternSyntaxException pse) {
                log.error((Object)pse.getMessage());
            }
        }
    }

    public void validateTel(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        String noTel = (String)value;
        if (StringUtils.isNotBlank((String)noTel)) {
            try {
                Pattern p = Pattern.compile(CST_PATTERN_TEL);
                Matcher m = p.matcher(noTel);
                if (!m.matches()) {
                    String msg = ComponentUtils.translate((FacesContext)context, (String)"label.toutatice.validator.bad.tel.format");
                    FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_ERROR, msg, null);
                    throw new ValidatorException(message);
                }
            }
            catch (PatternSyntaxException pse) {
                log.error((Object)pse.getMessage());
            }
        }
    }

    public void validateRNE(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        String rne = (String)value;
        if (StringUtils.isNotBlank((String)rne)) {
            try {
                Pattern p = Pattern.compile(CST_PATTERN_RNE);
                Matcher m = p.matcher(rne);
                if (!m.matches()) {
                    String msg = ComponentUtils.translate((FacesContext)context, (String)"label.acaren.validator.bad.rne.format");
                    FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_ERROR, msg, null);
                    throw new ValidatorException(message);
                }
            }
            catch (PatternSyntaxException pse) {
                log.error((Object)pse.getMessage());
            }
        }
    }

    public void validateISBN(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        String isbn = (String)value;
        if (StringUtils.isNotBlank((String)isbn)) {
            try {
                Pattern p = Pattern.compile(CST_PATTERN_ISBN);
                Matcher m = p.matcher(isbn);
                if (!m.matches()) {
                    String msg = ComponentUtils.translate((FacesContext)context, (String)"label.acaren.validator.bad.isbn.format");
                    FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_ERROR, msg, null);
                    throw new ValidatorException(message);
                }
                isbn = isbn.replaceAll("-", "");
                int sum = 0;
                if (isbn.length() == 10) {
                    for (int i = 0; i < 9; ++i) {
                        sum += isbn.charAt(i) * (i + 1);
                    }
                    sum = isbn.charAt(9) == 'X' || isbn.charAt(9) == 'x' ? (sum += 100) : (sum += 10 * isbn.charAt(9));
                    if (sum % 11 != 0) {
                        String msg = ComponentUtils.translate((FacesContext)context, (String)"label.acaren.validator.bad.isbn.cle");
                        FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_ERROR, msg, null);
                        throw new ValidatorException(message);
                    }
                } else if (isbn.length() == 13) {
                    for (int i = 0; i < 13; ++i) {
                        if ((i + 1) % 2 == 0) {
                            sum += 3 * isbn.charAt(i);
                            continue;
                        }
                        sum += isbn.charAt(i);
                    }
                    if (sum % 10 != 0) {
                        String msg = ComponentUtils.translate((FacesContext)context, (String)"label.acaren.validator.bad.isbn.cle");
                        FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_ERROR, msg, null);
                        throw new ValidatorException(message);
                    }
                }
            }
            catch (PatternSyntaxException pse) {
                log.error((Object)pse.getMessage());
            }
        }
    }
}

