/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.core.components;

import fr.toutatice.ecm.platform.core.components.ToutaticeAbstractServiceHandler;
import fr.toutatice.ecm.platform.core.components.ToutaticeServiceProvider;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLDocumentLive;
import org.nuxeo.ecm.core.versioning.VersioningService;

public class ToutaticeVersioningServiceHandler<T>
extends ToutaticeAbstractServiceHandler<T> {
    private static final List<String> filteredMethodsList = new ArrayList<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add("doPostCreate");
            this.add("doPreSave");
            this.add("doPostSave");
            this.add("doCheckIn");
            this.add("doCheckOut");
        }
    };

    @Override
    public T newProxy(T object, Class<T> itf) {
        this.setObject(object);
        return itf.cast(Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{itf}, (InvocationHandler)this));
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String sessionId = null;
        try {
            if (filteredMethodsList.contains(method.getName()) && null != args && 0 < args.length) {
                for (Object arg : args) {
                    if (!(arg instanceof SQLDocumentLive)) continue;
                    SQLDocumentLive document = (SQLDocumentLive)args[0];
                    sessionId = document.getSession().getSessionId();
                    break;
                }
                if (StringUtils.isNotBlank(sessionId) && ToutaticeServiceProvider.instance().isRegistered(VersioningService.class, sessionId)) {
                    return null;
                }
            }
            return method.invoke(this.object, args);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }
}

