/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.core.document;

import fr.toutatice.ecm.platform.core.services.infos.provider.DocumentInformationsProvider;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.model.PropertyNotFoundException;

public class ParentDocInfosProvider
implements DocumentInformationsProvider {
    private static final Log log = LogFactory.getLog(ParentDocInfosProvider.class);

    @Override
    public Map<String, Object> fetchInfos(CoreSession session, DocumentModel currentDocument) throws ClientException {
        HashMap<String, Object> infos = new HashMap<String, Object>(1);
        if (currentDocument.hasFacet("isRemoteProxy")) {
            GetUnrestrictedParentWebId runner = new GetUnrestrictedParentWebId(session, currentDocument);
            runner.runUnrestricted();
            infos.put("parentWebId", runner.get());
        }
        return infos;
    }

    private class GetUnrestrictedParentWebId
    extends UnrestrictedSessionRunner {
        private DocumentModel document;
        private String webId;

        protected GetUnrestrictedParentWebId(CoreSession session, DocumentModel document) {
            super(session);
            this.document = document;
        }

        public void run() throws ClientException {
            DocumentModel parent = this.session.getParentDocument(this.document.getRef());
            if (parent != null && parent.hasSchema("toutatice")) {
                try {
                    this.webId = (String)((Object)parent.getPropertyValue("ttc:webid"));
                }
                catch (PropertyNotFoundException pnfe) {
                    log.error((Object)("Document " + parent.getPathAsString() + " has no webId"));
                }
            }
        }

        public String get() {
            return this.webId;
        }
    }
}

