/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.core.local.configuration;

import fr.toutatice.ecm.platform.core.helper.ToutaticeDocumentHelper;
import fr.toutatice.ecm.platform.core.local.configuration.WebConfsConfiguration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.Filter;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.localconfiguration.AbstractLocalConfiguration;

public class WebConfsConfigurationAdapter
extends AbstractLocalConfiguration<WebConfsConfiguration>
implements WebConfsConfiguration {
    private static final Log log = LogFactory.getLog(WebConfsConfigurationAdapter.class);
    protected DocumentRef documentRef;
    protected List<DocumentModel> allConfsDocs;
    protected List<String> allowedConfsDocs;
    protected boolean denyAllConfsDocs;

    public WebConfsConfigurationAdapter(DocumentModel domain) {
        this.documentRef = domain.getRef();
        this.allowedConfsDocs = this.getWebConfsList(domain, "webconfs:allowedConfsDocs");
        this.denyAllConfsDocs = this.getDenyAllWebConfsProperty(domain);
    }

    @Override
    public List<DocumentModel> getAllConfsDocs() {
        return this.allConfsDocs;
    }

    @Override
    public void setAllConfsDocs(List<DocumentModel> allConfsDocs) {
        this.allConfsDocs = allConfsDocs;
    }

    @Override
    public List<String> getAllowedConfsDocs() {
        return this.allowedConfsDocs;
    }

    @Override
    public boolean getDenyAllConfsDocs() {
        return this.denyAllConfsDocs;
    }

    public DocumentRef getDocumentRef() {
        return this.documentRef;
    }

    protected List<String> getWebConfsList(DocumentModel doc, String property) {
        String[] webConfs;
        try {
            webConfs = (String[])doc.getPropertyValue(property);
        }
        catch (ClientException e) {
            return Collections.emptyList();
        }
        if (webConfs == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(Arrays.asList(webConfs));
    }

    protected boolean getDenyAllWebConfsProperty(DocumentModel domain) {
        try {
            Boolean value = (Boolean)domain.getPropertyValue("webconfs:denyAllConfsDocs");
            return Boolean.TRUE.equals(value);
        }
        catch (ClientException e) {
            return false;
        }
    }

    @Override
    public List<DocumentModel> getSelectedConfs(DocumentModel domain) throws ClientException {
        Boolean allDocsDenied;
        ArrayList<DocumentModel> selectedWebConfs = new ArrayList<DocumentModel>(0);
        if (domain.hasFacet("WebConfigurationsLocalConfiguration") && BooleanUtils.isNotTrue((Boolean)(allDocsDenied = (Boolean)domain.getPropertyValue("webconfs:denyAllConfsDocs")))) {
            List<String> allowedWebConfs = this.getAllowedWebConfs(domain);
            List<DocumentModel> allglobalWebConfs = this.getAllGlobalWebConfs(domain);
            for (String webConfCode : allowedWebConfs) {
                boolean found = false;
                Iterator<DocumentModel> iterator = allglobalWebConfs.iterator();
                while (iterator.hasNext() && !found) {
                    DocumentModel globalWebConf = iterator.next();
                    String confCode = (String)((Object)globalWebConf.getPropertyValue("wconf:code"));
                    if (!StringUtils.isNotBlank((String)confCode) || !webConfCode.equals(confCode)) continue;
                    selectedWebConfs.add(globalWebConf);
                    found = true;
                }
            }
        }
        return selectedWebConfs;
    }

    @Override
    public List<String> getAllowedWebConfs(DocumentModel doc) throws ClientException {
        List<String> allowedWebConfs = new ArrayList<String>(this.getAllowedConfsDocs());
        if (allowedWebConfs.isEmpty()) {
            allowedWebConfs = this.computeAllowedWebConfs(this.getAllGlobalWebConfs(doc));
        }
        return allowedWebConfs;
    }

    protected List<String> computeAllowedWebConfs(List<DocumentModel> webConfsDocs) {
        ArrayList<String> webConfsCodes = new ArrayList<String>(0);
        for (DocumentModel webConf : webConfsDocs) {
            String webConfCode = (String)((Object)webConf.getPropertyValue("wconf:code"));
            webConfsCodes.add(webConfCode);
        }
        return webConfsCodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DocumentModel> getAllGlobalWebConfs(DocumentModel domain) {
        ArrayList<DocumentModel> globalWebConfs = new ArrayList<DocumentModel>(0);
        List<DocumentModel> allConfsDocs = this.getAllConfsDocs();
        if (allConfsDocs != null) {
            globalWebConfs.addAll(allConfsDocs);
        } else {
            try (CoreSession coreSession = CoreInstance.openCoreSession((String)"default");){
                UnrestrictedGetGlobalWebConfs webConfsGetter = new UnrestrictedGetGlobalWebConfs(coreSession);
                webConfsGetter.runUnrestricted();
                DocumentModelList webConfs = webConfsGetter.getWebConfs();
                if (webConfs != null && !webConfs.isEmpty()) {
                    globalWebConfs.addAll((Collection<DocumentModel>)webConfs);
                    this.setAllConfsDocs((List<DocumentModel>)webConfs);
                }
            }
        }
        return globalWebConfs;
    }

    public static class UnrestrictedGetGlobalWebConfs
    extends UnrestrictedSessionRunner {
        private DocumentModelList webConfs;

        public DocumentModelList getWebConfs() {
            return this.webConfs;
        }

        public UnrestrictedGetGlobalWebConfs(CoreSession session) {
            super(session);
        }

        public void run() throws ClientException {
            Filter noDomainParent = new Filter(){
                private static final long serialVersionUID = 1L;

                public boolean accept(DocumentModel docModel) {
                    DocumentModel domain = ToutaticeDocumentHelper.getDomain(UnrestrictedGetGlobalWebConfs.this.session, docModel, true);
                    return domain == null;
                }
            };
            DocumentModel repo = this.session.getRootDocument();
            StringBuffer query = new StringBuffer().append("select * from ").append("WebConfiguration").append(" where ecm:ancestorId = '").append(repo.getId()).append("' and wconf:enabled=1 AND ecm:mixinType != 'HiddenInNavigation'  AND ecm:currentLifeCycleState <> 'deleted'");
            this.webConfs = this.session.query(query.toString(), noDomainParent);
        }
    }
}

