/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.core.query.helper;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.IterableQueryResult;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.elasticsearch.api.ElasticSearchService;
import org.nuxeo.elasticsearch.query.NxQueryBuilder;
import org.nuxeo.runtime.api.Framework;

public class ToutaticeEsQueryHelper {
    private static final Log log = LogFactory.getLog(ToutaticeEsQueryHelper.class);
    public static final int DEFAULT_MAX_RESULT_SIZE = 10000;
    public static final String DESCENDANTS_ID_QUERY = "select * from Document where ecm:path startswith '%s' %s and ecm:isVersion = 0 and ecm:mixinType <> 'HiddenInNavigation' and ecm:currentLifeCycleState <> 'deleted'";
    public static final String PROXIES_CLAUSE = " and ecm:isProxy = 1 ";
    public static final String LIVES_CLAUSE = " and ecm:isProxy = 0 ";
    public static final String NOT_VERSIONS_CLAUSE = " and ecm:isVersion = 0 ";
    private static ElasticSearchService ess;

    protected static ElasticSearchService getElasticSearchService() {
        if (ess == null) {
            ess = (ElasticSearchService)Framework.getService(ElasticSearchService.class);
        }
        return ess;
    }

    private ToutaticeEsQueryHelper() {
    }

    public static DocumentModelList getDescendants(CoreSession session, DocumentModel parent, boolean unrestricted, boolean published) {
        String clause = published ? PROXIES_CLAUSE : LIVES_CLAUSE;
        String nxql = String.format(DESCENDANTS_ID_QUERY, parent.getPathAsString(), clause);
        return ToutaticeEsQueryHelper.query(session, nxql, -1, unrestricted, false);
    }

    public static IterableQueryResult unrestrictedQueryAndAggregate(CoreSession session, String nxql) {
        return ToutaticeEsQueryHelper.unrestrictedQueryAndAggregate(session, nxql, false);
    }

    public static IterableQueryResult unrestrictedQueryAndAggregate(CoreSession session, String nxql, boolean fetchFromEs) {
        UnrestrictedQueryAndAggregate uQnA = new UnrestrictedQueryAndAggregate(session, nxql, fetchFromEs);
        uQnA.runUnrestricted();
        return uQnA.getRowsResults();
    }

    public static DocumentModelList query(CoreSession session, String nxql) {
        return ToutaticeEsQueryHelper.query(session, nxql, 0, -1, false);
    }

    public static DocumentModelList query(CoreSession session, String nxql, int limit) {
        return ToutaticeEsQueryHelper.query(session, nxql, 0, limit, false);
    }

    public static DocumentModelList query(CoreSession session, String nxql, int currentPageIndex, int pageSize) {
        return ToutaticeEsQueryHelper.query(session, nxql, currentPageIndex, pageSize, false);
    }

    public static DocumentModelList query(CoreSession session, String nxql, int currentPageIndex, int pageSize, boolean fetchDocFromEs) {
        NxQueryBuilder qB = new NxQueryBuilder(session).nxql(nxql);
        if (fetchDocFromEs) {
            qB.fetchFromElasticsearch();
        } else {
            qB.fetchFromDatabase();
        }
        if (pageSize > 0 && currentPageIndex >= 0) {
            qB.offset(currentPageIndex * pageSize);
            qB.limit(pageSize);
        } else {
            qB.limit(10000);
        }
        return ToutaticeEsQueryHelper.getElasticSearchService().query(qB);
    }

    public static DocumentModelList unrestrictedQuery(CoreSession session, String nxql, int limit) {
        UnrestrictedQuery uQry = new UnrestrictedQuery(session);
        uQry.setNxql(nxql);
        uQry.setPageSize(limit);
        uQry.runUnrestricted();
        return uQry.getDocuments();
    }

    public static DocumentModelList query(CoreSession session, String nxql, int limit, boolean unrestricted, boolean fetchDocFromEs) {
        UnrestrictedQuery uQry = new UnrestrictedQuery(session);
        uQry.setNxql(nxql);
        uQry.setPageSize(limit);
        uQry.setFetchDocFromEs(fetchDocFromEs);
        if (unrestricted) {
            uQry.runUnrestricted();
        } else {
            uQry.run();
        }
        return uQry.getDocuments();
    }

    public static class UnrestrictedQuery
    extends UnrestrictedSessionRunner {
        private String nxql;
        private int currentPageIndex = 0;
        private int pageSize = -1;
        private boolean fetchDocFromEs = false;
        private DocumentModelList documents;

        protected UnrestrictedQuery(CoreSession session) {
            super(session);
        }

        public void setNxql(String nxql) {
            this.nxql = nxql;
        }

        public void setCurrentPageIndex(int currentPageIndex) {
            this.currentPageIndex = currentPageIndex;
        }

        public void setPageSize(int pageSize) {
            this.pageSize = pageSize;
        }

        public boolean isFetchDocFromEs() {
            return this.fetchDocFromEs;
        }

        public void setFetchDocFromEs(boolean fetchDocFromEs) {
            this.fetchDocFromEs = fetchDocFromEs;
        }

        public DocumentModelList getDocuments() {
            return this.documents;
        }

        public void run() throws ClientException {
            long b_ = System.currentTimeMillis();
            this.documents = ToutaticeEsQueryHelper.query(this.session, this.nxql, this.currentPageIndex, this.pageSize, this.fetchDocFromEs);
            if (log.isDebugEnabled()) {
                long e_ = System.currentTimeMillis();
                String query_ = this.nxql != null ? this.nxql : "null";
                log.debug((Object)"Query [".concat(query_).concat("] executed on ES in [".concat(String.valueOf(e_ - b_).concat(" ms]"))));
            }
        }
    }

    public static class UnrestrictedQueryAndAggregate
    extends UnrestrictedSessionRunner {
        private String query;
        private int limit = -1;
        private IterableQueryResult iqr;
        private boolean fetchFromEs = false;

        protected UnrestrictedQueryAndAggregate(CoreSession session) {
            super(session);
        }

        protected UnrestrictedQueryAndAggregate(CoreSession session, String query, boolean fetchFromEs) {
            super(session);
            this.query = query;
            this.fetchFromEs = fetchFromEs;
        }

        public void setQuery(String query) {
            this.query = query;
        }

        public void setLimit(int limit) {
            this.limit = limit;
        }

        public IterableQueryResult getRowsResults() {
            return this.iqr;
        }

        public void run() throws ClientException {
            NxQueryBuilder queryBuilder;
            ElasticSearchService ess;
            if (StringUtils.isNotBlank((String)this.query)) {
                ess = ToutaticeEsQueryHelper.getElasticSearchService();
                queryBuilder = new NxQueryBuilder(this.session).nxql(this.query).limit(this.limit);
                if (this.fetchFromEs) {
                    queryBuilder.fetchFromElasticsearch();
                }
            } else {
                throw new ClientException("No query defined.");
            }
            this.iqr = ess.queryAndAggregate(queryBuilder).getRows();
        }
    }
}

