/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.convert.plugins.text.extractors;

import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class OpenXmlContentHandler
extends DefaultHandler {
    protected final StringBuffer sb = new StringBuffer();
    protected final Stack<String> path = new Stack();
    protected boolean dumpText = false;

    public String getContent() {
        return this.sb.toString();
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        this.path.push(qName);
        if (qName.equals("w:t") || qName.equals("a:t")) {
            this.dumpText = true;
        }
        if (qName.equals("w:pStyle") && !"style0".equals(atts.getValue("w:val")) && !"style1".equals(atts.getValue("w:val"))) {
            this.sb.append("\n");
        }
        if (qName.equals("w:p") || qName.equals("a:p")) {
            this.sb.append("\n");
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.dumpText) {
            String content = String.valueOf(ch, start, length);
            this.sb.append(content);
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.path.pop();
        if (this.path.isEmpty() || !((String)this.path.lastElement()).equals("w:t")) {
            this.dumpText = false;
        }
    }
}

