/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.collections.list;

import com.phloc.commons.IHasSize;
import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.collections.ArrayHelper;
import com.phloc.commons.collections.iterate.EmptyIterator;
import com.phloc.commons.collections.iterate.EmptyListIterator;
import com.phloc.commons.collections.iterate.SingleElementIterator;
import com.phloc.commons.collections.iterate.SingleElementListIterator;
import com.phloc.commons.equals.EqualsUtils;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.lang.GenericReflection;
import com.phloc.commons.string.ToStringGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class SingleElementList<ELEMENTTYPE>
implements List<ELEMENTTYPE>,
IHasSize {
    private boolean m_bHasElement;
    private ELEMENTTYPE m_aElement;

    public SingleElementList() {
        this.m_bHasElement = false;
        this.m_aElement = null;
    }

    public SingleElementList(@Nullable ELEMENTTYPE ELEMENTTYPE) {
        this.m_bHasElement = true;
        this.m_aElement = ELEMENTTYPE;
    }

    @Override
    public boolean add(@Nullable ELEMENTTYPE ELEMENTTYPE) {
        if (this.m_bHasElement) {
            throw new IllegalStateException("List already contains an element");
        }
        this.m_aElement = ELEMENTTYPE;
        this.m_bHasElement = true;
        return true;
    }

    @Override
    public void add(@Nonnegative int n, @Nullable ELEMENTTYPE ELEMENTTYPE) {
        if (n != 0) {
            throw new IllegalArgumentException("Only 1 elements is allowed: " + n);
        }
        if (this.m_bHasElement) {
            throw new IllegalStateException("List already contains an element");
        }
        this.m_aElement = ELEMENTTYPE;
        this.m_bHasElement = true;
    }

    @Override
    public boolean addAll(@Nonnull Collection<? extends ELEMENTTYPE> collection) {
        if (collection.size() > 1) {
            throw new IllegalArgumentException("Cannot add lists with more than one element!");
        }
        if (this.m_bHasElement) {
            throw new IllegalStateException("List already contains an element");
        }
        Iterator<ELEMENTTYPE> iterator = collection.iterator();
        return iterator.hasNext() && this.add(iterator.next());
    }

    @Override
    public boolean addAll(@Nonnegative int n, @Nonnull Collection<? extends ELEMENTTYPE> collection) {
        if (n != 0) {
            throw new IndexOutOfBoundsException("Only index 0 is valid!");
        }
        return this.addAll(collection);
    }

    @Override
    public void clear() {
        this.m_aElement = null;
        this.m_bHasElement = false;
    }

    @Override
    public boolean contains(@Nullable Object object) {
        return this.m_bHasElement && EqualsUtils.equals(this.m_aElement, object);
    }

    @Override
    public boolean containsAll(@Nonnull Collection<?> collection) {
        for (Object obj : collection) {
            if (this.contains(obj)) continue;
            return false;
        }
        return true;
    }

    @Override
    public ELEMENTTYPE get(@Nonnegative int n) {
        if (!this.m_bHasElement || n != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this.m_aElement;
    }

    @Override
    public int indexOf(Object object) {
        return this.contains(object) ? 0 : -1;
    }

    @Override
    public boolean isEmpty() {
        return !this.m_bHasElement;
    }

    @Override
    @Nonnull
    public Iterator<ELEMENTTYPE> iterator() {
        return this.m_bHasElement ? SingleElementIterator.create(this.m_aElement) : EmptyIterator.getInstance();
    }

    @Override
    public int lastIndexOf(@Nullable Object object) {
        return this.contains(object) ? 0 : -1;
    }

    @Override
    @Nonnull
    public ListIterator<ELEMENTTYPE> listIterator() {
        return this.m_bHasElement ? SingleElementListIterator.create(this.m_aElement) : EmptyListIterator.getInstance();
    }

    @Override
    @Nonnull
    public ListIterator<ELEMENTTYPE> listIterator(int n) {
        if (!this.m_bHasElement || n != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this.listIterator();
    }

    @Override
    @Nullable
    public ELEMENTTYPE remove(int n) {
        if (!this.m_bHasElement || n != 0) {
            throw new IndexOutOfBoundsException();
        }
        ELEMENTTYPE ELEMENTTYPE = this.m_aElement;
        this.m_aElement = null;
        this.m_bHasElement = false;
        return ELEMENTTYPE;
    }

    @Override
    public boolean remove(Object object) {
        if (!this.contains(object)) {
            return false;
        }
        this.m_aElement = null;
        this.m_bHasElement = false;
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean bl = true;
        for (Object obj : collection) {
            if (this.remove(obj)) continue;
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean retainAll(@Nonnull Collection<?> collection) {
        if (this.m_bHasElement) {
            if (collection.contains(this.m_aElement)) {
                return true;
            }
            this.clear();
        }
        return false;
    }

    @Override
    @Nullable
    public ELEMENTTYPE set(@Nonnegative int n, @Nullable ELEMENTTYPE ELEMENTTYPE) {
        if (n != 0) {
            throw new IllegalArgumentException("The passed index can onyl be 0!");
        }
        ELEMENTTYPE ELEMENTTYPE2 = this.m_aElement;
        this.m_bHasElement = true;
        this.m_aElement = ELEMENTTYPE;
        return ELEMENTTYPE2;
    }

    @Override
    @Nonnegative
    public int size() {
        return this.m_bHasElement ? 1 : 0;
    }

    @Override
    @Nonnull
    public List<ELEMENTTYPE> subList(int n, int n2) {
        if (!this.m_bHasElement || n != 0 || n2 != 0) {
            throw new IndexOutOfBoundsException();
        }
        ArrayList<ELEMENTTYPE> arrayList = new ArrayList<ELEMENTTYPE>();
        if (this.m_bHasElement) {
            arrayList.add(this.m_aElement);
        }
        return arrayList;
    }

    @Override
    @Nonnull
    public Object[] toArray() {
        if (this.m_bHasElement) {
            Object[] objectArray = new Object[]{this.m_aElement};
            return objectArray;
        }
        return ArrayHelper.EMPTY_OBJECT_ARRAY;
    }

    @Override
    @Nonnull
    public <ARRAYELEMENTTYPE> ARRAYELEMENTTYPE[] toArray(@Nonnull ARRAYELEMENTTYPE[] ARRAYELEMENTTYPEArray) {
        ValueEnforcer.notNull(ARRAYELEMENTTYPEArray, "Dest");
        if (!this.m_bHasElement) {
            return ARRAYELEMENTTYPEArray;
        }
        if (this.m_aElement != null && !ARRAYELEMENTTYPEArray.getClass().getComponentType().isAssignableFrom(this.m_aElement.getClass())) {
            throw new ArrayStoreException("The array class " + ARRAYELEMENTTYPEArray.getClass() + " cannot store the item of class " + this.m_aElement.getClass());
        }
        ARRAYELEMENTTYPE[] ARRAYELEMENTTYPEArray2 = ARRAYELEMENTTYPEArray.length < 1 ? ArrayHelper.newArraySameType(ARRAYELEMENTTYPEArray, 1) : ARRAYELEMENTTYPEArray;
        ARRAYELEMENTTYPEArray2[0] = GenericReflection.uncheckedCast(this.m_aElement);
        if (ARRAYELEMENTTYPEArray2.length > 1) {
            ARRAYELEMENTTYPEArray2[1] = null;
        }
        return ARRAYELEMENTTYPEArray2;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        SingleElementList singleElementList = (SingleElementList)object;
        return this.m_bHasElement == singleElementList.m_bHasElement && EqualsUtils.equals(this.m_aElement, singleElementList.m_aElement);
    }

    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_bHasElement).append(this.m_aElement).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("hasElement", this.m_bHasElement).append("element", this.m_aElement).toString();
    }

    @Nonnull
    public static <ELEMENTTYPE> SingleElementList<ELEMENTTYPE> create(@Nullable ELEMENTTYPE ELEMENTTYPE) {
        return new SingleElementList<ELEMENTTYPE>(ELEMENTTYPE);
    }
}

