/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.concurrent;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.state.EInterrupt;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public final class ManagedExecutorService {
    private static final Logger s_aLogger = LoggerFactory.getLogger(ManagedExecutorService.class);
    private final ExecutorService m_aES;

    public ManagedExecutorService(@Nonnull ExecutorService executorService) {
        this.m_aES = ValueEnforcer.notNull(executorService, "ExecutorService");
    }

    @Nonnull
    public EInterrupt shutdownAndWaitUntilAllTasksAreFinished() {
        if (!this.m_aES.isShutdown()) {
            this.m_aES.shutdown();
            try {
                while (!this.m_aES.awaitTermination(1L, TimeUnit.SECONDS)) {
                }
            }
            catch (InterruptedException interruptedException) {
                s_aLogger.error("Error waiting for Executor service " + this.m_aES + " to end", (Throwable)interruptedException);
                return EInterrupt.INTERRUPTED;
            }
        }
        return EInterrupt.NOT_INTERRUPTED;
    }

    @Nonnull
    public static EInterrupt shutdownAndWaitUntilAllTasksAreFinished(@Nonnull ExecutorService executorService) {
        return new ManagedExecutorService(executorService).shutdownAndWaitUntilAllTasksAreFinished();
    }
}

