/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.io.streams;

import com.phloc.commons.ValueEnforcer;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class NonBlockingBufferedOutputStream
extends FilterOutputStream {
    protected byte[] m_aBuf;
    protected int m_nCount;

    public NonBlockingBufferedOutputStream(@Nonnull OutputStream outputStream) {
        this(outputStream, 8192);
    }

    public NonBlockingBufferedOutputStream(@Nonnull OutputStream outputStream, @Nonnegative int n) {
        super(outputStream);
        ValueEnforcer.isGT0(n, "Size");
        this.m_aBuf = new byte[n];
    }

    private void _flushBuffer() throws IOException {
        if (this.m_nCount > 0) {
            this.out.write(this.m_aBuf, 0, this.m_nCount);
            this.m_nCount = 0;
        }
    }

    @Override
    public void write(int n) throws IOException {
        if (this.m_nCount >= this.m_aBuf.length) {
            this._flushBuffer();
        }
        this.m_aBuf[this.m_nCount++] = (byte)n;
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (n2 >= this.m_aBuf.length) {
            this._flushBuffer();
            this.out.write(byArray, n, n2);
            return;
        }
        if (n2 > this.m_aBuf.length - this.m_nCount) {
            this._flushBuffer();
        }
        System.arraycopy(byArray, n, this.m_aBuf, this.m_nCount, n2);
        this.m_nCount += n2;
    }

    @Override
    public void flush() throws IOException {
        this._flushBuffer();
        this.out.flush();
    }
}

