/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.lang;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.annotations.ReturnsImmutableObject;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.priviledged.PrivilegedActionGetClassLoader;
import com.phloc.commons.priviledged.PrivilegedActionGetContextClassLoader;
import com.phloc.commons.priviledged.PrivilegedActionGetSystemClassLoader;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.AccessController;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class ClassHelper {
    private static final Map<Class<?>, Class<?>> PRIMITIVE_TO_WRAPPER = new WeakHashMap(8);
    private static final Map<Class<?>, Class<?>> WRAPPER_TO_PRIMITIVE = new WeakHashMap(8);
    private static final ClassHelper s_aInstance;

    private static void _registerPrimitiveMapping(@Nonnull Class<?> clazz, @Nonnull Class<?> clazz2) {
        PRIMITIVE_TO_WRAPPER.put(clazz, clazz2);
        WRAPPER_TO_PRIMITIVE.put(clazz2, clazz);
    }

    private ClassHelper() {
    }

    @Nonnull
    public static ClassLoader getSystemClassLoader() {
        if (System.getSecurityManager() == null) {
            return ClassLoader.getSystemClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedActionGetSystemClassLoader());
    }

    @Nonnull
    public static ClassLoader getContextClassLoader() {
        if (System.getSecurityManager() == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedActionGetContextClassLoader());
    }

    @Nonnull
    public static ClassLoader getClassClassLoader(@Nonnull Class<?> clazz) {
        if (System.getSecurityManager() == null) {
            return clazz.getClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedActionGetClassLoader(clazz));
    }

    @Nonnull
    public static ClassLoader getDefaultClassLoader() {
        ClassLoader classLoader = null;
        try {
            classLoader = ClassHelper.getContextClassLoader();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (classLoader == null) {
            classLoader = ClassHelper.getClassClassLoader(ClassHelper.class);
        }
        return classLoader;
    }

    public static boolean isPublicClass(@Nullable Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        if (clazz.isInterface() || clazz.isAnnotation()) {
            return false;
        }
        if (!ClassHelper.isPublic(clazz)) {
            return false;
        }
        return !ClassHelper.isAbstractClass(clazz);
    }

    public static boolean isInstancableClass(@Nullable Class<?> clazz) {
        if (!ClassHelper.isPublicClass(clazz)) {
            return false;
        }
        try {
            clazz.getConstructor(null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
        return true;
    }

    public static boolean isPublic(@Nullable Class<?> clazz) {
        return clazz != null && Modifier.isPublic(clazz.getModifiers());
    }

    public static boolean isInterface(@Nullable Class<?> clazz) {
        return clazz != null && Modifier.isInterface(clazz.getModifiers());
    }

    public static boolean isAnnotationClass(@Nullable Class<?> clazz) {
        return clazz != null && clazz.isAnnotation();
    }

    public static boolean isEnumClass(@Nullable Class<?> clazz) {
        return clazz != null && clazz.isEnum();
    }

    public static boolean isAbstractClass(@Nullable Class<?> clazz) {
        return clazz != null && !clazz.isArray() && Modifier.isAbstract(clazz.getModifiers());
    }

    public static boolean isArrayClass(@Nullable Class<?> clazz) {
        return clazz != null && clazz.isArray();
    }

    public static boolean isPrimitiveType(@Nullable Class<?> clazz) {
        return clazz != null && PRIMITIVE_TO_WRAPPER.containsKey(clazz);
    }

    public static boolean isPrimitiveWrapperType(@Nullable Class<?> clazz) {
        return clazz != null && WRAPPER_TO_PRIMITIVE.containsKey(clazz);
    }

    @Nullable
    public static Class<?> getPrimitiveWrapperClass(@Nullable Class<?> clazz) {
        if (ClassHelper.isPrimitiveWrapperType(clazz)) {
            return clazz;
        }
        return PRIMITIVE_TO_WRAPPER.get(clazz);
    }

    @Nullable
    public static Class<?> getPrimitiveClass(@Nullable Class<?> clazz) {
        if (ClassHelper.isPrimitiveType(clazz)) {
            return clazz;
        }
        return WRAPPER_TO_PRIMITIVE.get(clazz);
    }

    @Nonnull
    @ReturnsImmutableObject
    public static Set<Class<?>> getAllPrimitiveClasses() {
        return ContainerHelper.makeUnmodifiable(PRIMITIVE_TO_WRAPPER.keySet());
    }

    @Nonnull
    @ReturnsImmutableObject
    public static Set<Class<?>> getAllPrimitiveWrapperClasses() {
        return ContainerHelper.makeUnmodifiable(WRAPPER_TO_PRIMITIVE.keySet());
    }

    public static boolean isStringClass(@Nullable Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        return CharSequence.class.isAssignableFrom(clazz);
    }

    public static boolean isCharacterClass(@Nullable Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        return Character.class.isAssignableFrom(clazz) || Character.TYPE.isAssignableFrom(clazz);
    }

    public static boolean isBooleanClass(@Nullable Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        return Boolean.class.isAssignableFrom(clazz) || Boolean.TYPE.isAssignableFrom(clazz);
    }

    public static boolean isFloatingPointClass(@Nullable Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        return Double.class.isAssignableFrom(clazz) || Double.TYPE.isAssignableFrom(clazz) || Float.class.isAssignableFrom(clazz) || Float.TYPE.isAssignableFrom(clazz) || BigDecimal.class.isAssignableFrom(clazz);
    }

    public static boolean isIntegerClass(@Nullable Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        return Byte.class.isAssignableFrom(clazz) || Byte.TYPE.isAssignableFrom(clazz) || Integer.class.isAssignableFrom(clazz) || Integer.TYPE.isAssignableFrom(clazz) || Long.class.isAssignableFrom(clazz) || Long.TYPE.isAssignableFrom(clazz) || Short.class.isAssignableFrom(clazz) || Short.TYPE.isAssignableFrom(clazz) || BigInteger.class.isAssignableFrom(clazz);
    }

    public static boolean areConvertibleClasses(@Nonnull Class<?> clazz, @Nonnull Class<?> clazz2) {
        ValueEnforcer.notNull(clazz, "SrcClass");
        ValueEnforcer.notNull(clazz2, "DstClass");
        if (clazz2.equals(clazz)) {
            return true;
        }
        if (clazz2.isAssignableFrom(clazz)) {
            return true;
        }
        if (clazz2 == ClassHelper.getPrimitiveWrapperClass(clazz)) {
            return true;
        }
        return clazz2 == ClassHelper.getPrimitiveClass(clazz);
    }

    @Nullable
    public static Class<?> getClass(@Nullable Object object) {
        return object == null ? null : object.getClass();
    }

    static {
        ClassHelper._registerPrimitiveMapping(Boolean.TYPE, Boolean.class);
        ClassHelper._registerPrimitiveMapping(Byte.TYPE, Byte.class);
        ClassHelper._registerPrimitiveMapping(Character.TYPE, Character.class);
        ClassHelper._registerPrimitiveMapping(Double.TYPE, Double.class);
        ClassHelper._registerPrimitiveMapping(Float.TYPE, Float.class);
        ClassHelper._registerPrimitiveMapping(Integer.TYPE, Integer.class);
        ClassHelper._registerPrimitiveMapping(Long.TYPE, Long.class);
        ClassHelper._registerPrimitiveMapping(Short.TYPE, Short.class);
        s_aInstance = new ClassHelper();
    }
}

