/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.serialize.convert;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.lang.ClassHierarchyCache;
import com.phloc.commons.lang.ServiceLoaderUtils;
import com.phloc.commons.serialize.convert.ISerializationConverter;
import com.phloc.commons.serialize.convert.ISerializationConverterCallback;
import com.phloc.commons.serialize.convert.ISerializationConverterRegistrarSPI;
import com.phloc.commons.serialize.convert.ISerializationConverterRegistry;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class SerializationConverterRegistry
implements ISerializationConverterRegistry {
    private static final SerializationConverterRegistry s_aInstance = new SerializationConverterRegistry();
    private static final Logger s_aLogger = LoggerFactory.getLogger(SerializationConverterRegistry.class);
    private static final ReadWriteLock s_aRWLock = new ReentrantReadWriteLock();
    @GuardedBy(value="s_aRWLock")
    private static final Map<Class<?>, ISerializationConverter> s_aMap = new WeakHashMap();

    private SerializationConverterRegistry() {
    }

    @Nonnull
    public static SerializationConverterRegistry getInstance() {
        return s_aInstance;
    }

    @Override
    public void registerSerializationConverter(@Nonnull Class<?> clazz, @Nonnull ISerializationConverter iSerializationConverter) {
        SerializationConverterRegistry._registerSerializationConverter(clazz, iSerializationConverter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _registerSerializationConverter(@Nonnull Class<?> clazz, @Nonnull ISerializationConverter iSerializationConverter) {
        ValueEnforcer.notNull(clazz, "Class");
        ValueEnforcer.notNull(iSerializationConverter, "Converter");
        if (Serializable.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("The provided " + clazz.toString() + " is already Serializable!");
        }
        s_aRWLock.writeLock().lock();
        try {
            if (s_aMap.containsKey(clazz)) {
                throw new IllegalArgumentException("A micro type converter for class " + clazz + " is already registered!");
            }
            for (WeakReference<Class<?>> weakReference : ClassHierarchyCache.getClassHierarchyIterator(clazz)) {
                Class clazz2 = (Class)weakReference.get();
                if (clazz2 == null || s_aMap.containsKey(clazz2)) continue;
                s_aMap.put(clazz2, iSerializationConverter);
                if (!s_aLogger.isDebugEnabled()) continue;
                s_aLogger.debug("Registered serialization converter for '" + clazz2.toString() + "'");
            }
        }
        finally {
            s_aRWLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static ISerializationConverter getConverter(@Nullable Class<?> clazz) {
        s_aRWLock.readLock().lock();
        try {
            ISerializationConverter iSerializationConverter = s_aMap.get(clazz);
            if (iSerializationConverter == null) {
                for (WeakReference weakReference : ClassHierarchyCache.getClassHierarchyIterator(clazz)) {
                    Class clazz2 = (Class)weakReference.get();
                    if (clazz2 == null || (iSerializationConverter = s_aMap.get(clazz2)) == null) continue;
                    if (!s_aLogger.isDebugEnabled()) break;
                    s_aLogger.debug("Using serialization converter " + iSerializationConverter + " for class " + clazz + " based on " + clazz2);
                    break;
                }
            }
            ISerializationConverter iSerializationConverter2 = iSerializationConverter;
            return iSerializationConverter2;
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void iterateAllRegisteredSerializationConverters(@Nonnull ISerializationConverterCallback iSerializationConverterCallback) {
        Map<Class<?>, ISerializationConverter> map;
        s_aRWLock.readLock().lock();
        try {
            map = ContainerHelper.newMap(s_aMap);
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
        for (Map.Entry<Class<?>, ISerializationConverter> entry : map.entrySet()) {
            if (iSerializationConverterCallback.call(entry.getKey(), entry.getValue()).isBreak()) break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnegative
    public static int getRegisteredSerializationConverterCount() {
        s_aRWLock.readLock().lock();
        try {
            int n = s_aMap.size();
            return n;
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
    }

    static {
        for (ISerializationConverterRegistrarSPI iSerializationConverterRegistrarSPI : ServiceLoaderUtils.getAllSPIImplementations(ISerializationConverterRegistrarSPI.class)) {
            iSerializationConverterRegistrarSPI.registerSerializationConverter(s_aInstance);
        }
        s_aLogger.info(SerializationConverterRegistry.getRegisteredSerializationConverterCount() + " serialization converters registered");
    }
}

