/*
 * Decompiled with CFR 0.152.
 */
package com.noelios.restlet.http;

import java.io.IOException;
import java.util.Date;
import java.util.logging.Logger;
import org.restlet.Application;
import org.restlet.data.Form;
import org.restlet.data.Parameter;
import org.restlet.data.Protocol;
import org.restlet.data.Request;
import org.restlet.service.ConnectorService;
import org.restlet.util.DateUtils;
import org.restlet.util.Series;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpCall {
    private final Series<Parameter> requestHeaders = new Form();
    private final Series<Parameter> responseHeaders = new Form();
    private Logger logger;
    private String hostDomain = null;
    private int hostPort = -1;
    private boolean confidential = false;
    private String clientAddress = null;
    private int clientPort = -1;
    private String method = null;
    private Protocol protocol = null;
    private String reasonPhrase = "";
    private String requestUri = null;
    private String serverAddress = null;
    private int serverPort = -1;
    private int statusCode = 200;
    private String version = null;

    public String formatDate(Date date, boolean cookie) {
        if (cookie) {
            return DateUtils.format(date, DateUtils.FORMAT_RFC_1036.get(0));
        }
        return DateUtils.format(date, DateUtils.FORMAT_RFC_1123.get(0));
    }

    public String getClientAddress() {
        return this.clientAddress;
    }

    public int getClientPort() {
        return this.clientPort;
    }

    public ConnectorService getConnectorService(Request request) {
        ConnectorService result = null;
        Application application = (Application)request.getAttributes().get("org.restlet.application");
        result = application != null ? application.getConnectorService() : new ConnectorService();
        return result;
    }

    public String getHostDomain() {
        return this.hostDomain;
    }

    public int getHostPort() {
        return this.hostPort;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public String getMethod() {
        return this.method;
    }

    public Protocol getProtocol() {
        if (this.protocol == null) {
            this.protocol = this.isConfidential() ? Protocol.HTTPS : Protocol.HTTP;
        }
        return this.protocol;
    }

    public String getReasonPhrase() {
        return this.reasonPhrase;
    }

    public Series<Parameter> getRequestHeaders() {
        return this.requestHeaders;
    }

    public String getRequestUri() {
        return this.requestUri;
    }

    public Series<Parameter> getResponseHeaders() {
        return this.responseHeaders;
    }

    public String getServerAddress() {
        return this.serverAddress;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public int getStatusCode() throws IOException {
        return this.statusCode;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isConfidential() {
        return this.confidential;
    }

    public Date parseDate(String date, boolean cookie) {
        if (cookie) {
            return DateUtils.parse(date, DateUtils.FORMAT_RFC_1036);
        }
        return DateUtils.parse(date, DateUtils.FORMAT_RFC_1123);
    }

    protected void setClientAddress(String clientAddress) {
        this.clientAddress = clientAddress;
    }

    protected void setClientPort(int clientPort) {
        this.clientPort = clientPort;
    }

    protected void setConfidential(boolean confidential) {
        this.confidential = confidential;
    }

    public void setHostDomain(String hostDomain) {
        this.hostDomain = hostDomain;
    }

    public void setHostPort(int hostPort) {
        this.hostPort = hostPort;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    protected void setMethod(String method) {
        this.method = method;
    }

    public void setProtocol(Protocol protocol) {
        this.protocol = protocol;
    }

    public void setReasonPhrase(String reasonPhrase) {
        this.reasonPhrase = reasonPhrase;
    }

    protected void setRequestUri(String requestUri) {
        if (requestUri == null || requestUri.equals("")) {
            requestUri = "/";
        }
        this.requestUri = requestUri;
    }

    public void setServerAddress(String responseAddress) {
        this.serverAddress = responseAddress;
    }

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }

    public void setStatusCode(int code) {
        this.statusCode = code;
    }

    public void setVersion(String version) {
        this.version = version;
    }
}

