/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.oauth2.request;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class Oauth2Request {
    private static final Log log = LogFactory.getLog(Oauth2Request.class);
    public static final String CLIENT_ID = "client_id";
    public static final String REDIRECT_URI = "redirect_uri";
    public static final String REDIRECT_URL = "redirect_url";
    protected String clientId;
    protected String redirectUri;

    public Oauth2Request() {
    }

    public Oauth2Request(HttpServletRequest request) {
        this.clientId = request.getParameter(CLIENT_ID);
        this.redirectUri = Oauth2Request.decodeParameter(request, REDIRECT_URI);
        if (StringUtils.isBlank((String)this.redirectUri)) {
            this.redirectUri = Oauth2Request.decodeParameter(request, REDIRECT_URL);
        }
    }

    public static String decodeParameter(HttpServletRequest request, String parameterName) {
        String value = request.getParameter(parameterName);
        try {
            if (StringUtils.isNotBlank((String)value)) {
                return URLDecoder.decode(value, "UTF-8");
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return value;
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public String getClientId() {
        return this.clientId;
    }
}

