/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.binary;

import java.io.File;
import java.io.IOException;
import org.nuxeo.ecm.core.storage.binary.AbstractBinaryManager;
import org.nuxeo.ecm.core.storage.binary.Binary;
import org.nuxeo.ecm.core.storage.binary.BinaryManagerDescriptor;
import org.nuxeo.ecm.core.storage.binary.BinaryScrambler;
import org.nuxeo.ecm.core.storage.binary.LocalBinaryManager;

public class XORBinaryManager
extends LocalBinaryManager {
    protected byte[] pattern;

    @Override
    public void initialize(BinaryManagerDescriptor binaryManagerDescriptor) throws IOException {
        super.initialize(binaryManagerDescriptor);
        String key = binaryManagerDescriptor.key;
        if (key == null || key.length() == 0) {
            key = "U";
        }
        try {
            this.pattern = key.getBytes("UTF-8");
        }
        catch (Exception e) {
            this.pattern = new byte[]{85};
        }
    }

    @Override
    protected BinaryScrambler getBinaryScrambler() {
        return new XORBinaryScrambler(this.pattern);
    }

    public static class XORBinaryScrambler
    implements BinaryScrambler {
        private static final long serialVersionUID = 1L;
        protected final byte[] pattern;
        protected long pos;

        public XORBinaryScrambler(byte[] pattern) {
            this.pattern = pattern;
            this.pos = 0L;
        }

        @Override
        public void scrambleBuffer(byte[] buf, int off, int n) {
            for (int i = 0; i < n; ++i) {
                int n2 = off + i;
                buf[n2] = (byte)(buf[n2] ^ this.pattern[(int)(this.pos % (long)this.pattern.length)]);
                ++this.pos;
            }
        }

        @Override
        public void unscrambleBuffer(byte[] buf, int off, int n) {
            this.scrambleBuffer(buf, off, n);
        }

        @Override
        public Binary getUnscrambledBinary(File file, String digest, String repoName) {
            return new AbstractBinaryManager.ScrambledBinary(file, digest, repoName, this);
        }

        @Override
        public void skip(long n) {
            this.pos += n;
        }

        @Override
        public void reset() {
            this.pos = 0L;
        }
    }
}

