/*
 * Decompiled with CFR 0.152.
 */
package org.etherpad_lite_client;

import java.net.URI;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.etherpad_lite_client.EPLiteException;
import org.etherpad_lite_client.GETRequest;
import org.etherpad_lite_client.POSTRequest;
import org.etherpad_lite_client.Request;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class EPLiteConnection {
    public static final int CODE_OK = 0;
    public static final int CODE_INVALID_PARAMETERS = 1;
    public static final int CODE_INTERNAL_ERROR = 2;
    public static final int CODE_INVALID_METHOD = 3;
    public static final int CODE_INVALID_API_KEY = 4;
    public URI uri;
    public String apiKey;
    public String apiVersion;

    public EPLiteConnection(String url, String apiKey, String apiVersion) {
        this.uri = URI.create(url);
        this.apiKey = apiKey;
        this.apiVersion = apiVersion;
    }

    public HashMap get(String apiMethod) {
        return this.get(apiMethod, new HashMap());
    }

    public HashMap get(String apiMethod, HashMap apiArgs) {
        String path = this.apiPath(apiMethod);
        String query = this.queryString(apiArgs);
        URL url = this.apiUrl(path, query);
        GETRequest request = new GETRequest(url);
        return this.call(request);
    }

    public HashMap post(String apiMethod) {
        return this.post(apiMethod, new HashMap());
    }

    public HashMap post(String apiMethod, HashMap apiArgs) {
        String path = this.apiPath(apiMethod);
        String query = this.queryString(apiArgs);
        URL url = this.apiUrl(path, null);
        POSTRequest request = new POSTRequest(url, query);
        return this.call(request);
    }

    private HashMap call(Request request) {
        this.trustServerAndCertificate();
        try {
            String response = request.send();
            return this.handleResponse(response);
        }
        catch (EPLiteException e) {
            throw new EPLiteException(e.getMessage());
        }
        catch (Exception e) {
            throw new EPLiteException("Unable to connect to Etherpad Lite instance (" + e.getClass() + "): " + e.getMessage());
        }
    }

    private HashMap handleResponse(String jsonString) {
        try {
            JSONParser parser = new JSONParser();
            Map response = (Map)parser.parse(jsonString);
            if (!response.get("code").equals(null)) {
                int code = ((Long)response.get("code")).intValue();
                switch (code) {
                    case 0: {
                        HashMap data = (HashMap)response.get("data");
                        return data != null ? data : new HashMap();
                    }
                    case 1: 
                    case 3: 
                    case 4: {
                        throw new EPLiteException((String)response.get("message"));
                    }
                }
                throw new EPLiteException("An unknown error has occurred while handling the response: " + jsonString);
            }
            throw new EPLiteException("An unknown error has occurred while handling the response: " + jsonString);
        }
        catch (ParseException e) {
            System.err.println("Unable to parse JSON response (" + jsonString + "): " + e.getMessage());
            return new HashMap();
        }
    }

    private URL apiUrl(String path, String query) {
        try {
            URL url = new URL(new URI(this.uri.getScheme(), null, this.uri.getHost(), this.uri.getPort(), path, query, null).toString());
            return url;
        }
        catch (Exception e) {
            throw new EPLiteException("Unable to connect to Etherpad Lite instance (" + e.getClass() + "): " + e.getMessage());
        }
    }

    private String apiPath(String apiMethod) {
        return this.uri.getPath() + "/api/" + this.apiVersion + "/" + apiMethod;
    }

    private String queryString(HashMap apiArgs) {
        String strArgs = "";
        apiArgs.put("apikey", this.apiKey);
        Iterator i = apiArgs.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            Object value = e.getValue();
            if (value == null) continue;
            strArgs = strArgs + e.getKey() + "=" + value;
            if (!i.hasNext()) continue;
            strArgs = strArgs + "&";
        }
        return strArgs;
    }

    private void trustServerAndCertificate() {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        }
        catch (Exception e) {
            // empty catch block
        }
        HostnameVerifier hv = new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        };
        HttpsURLConnection.setDefaultHostnameVerifier(hv);
    }
}

