/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.addons.toutapad.ecm.listeners;

import fr.toutatice.addons.toutapad.ecm.services.EtherpadClientService;
import fr.toutatice.ecm.platform.core.listener.ToutaticeDocumentEventListenerHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.runtime.api.Framework;

public class ToutapadEventListenerCopyPad
implements EventListener {
    private static final Log log = LogFactory.getLog(ToutapadEventListenerCopyPad.class);
    private EtherpadClientService service = null;

    public void handleEvent(Event event) throws ClientException {
        DocumentEventContext eventContext;
        DocumentModel to;
        if (event.getContext() instanceof DocumentEventContext && "ToutaticePad".equals((to = (eventContext = (DocumentEventContext)event.getContext()).getSourceDocument()).getType()) && ToutaticeDocumentEventListenerHelper.isAlterableDocument((DocumentModel)to)) {
            try {
                DocumentRef createdFrom = (DocumentRef)eventContext.getProperty("sourceRef");
                if (createdFrom != null) {
                    CoreSession coreSession = eventContext.getCoreSession();
                    DocumentModel from = coreSession.getDocument(createdFrom);
                    this.getEtherpadClientService().copyPAD(from, to);
                } else {
                    this.getEtherpadClientService().createPAD(to);
                }
            }
            catch (Exception e) {
                log.error((Object)("Failed to copy a pad, error: " + e.getMessage()));
                event.markRollBack("Impossible de copier le PAD '" + to.getTitle() + "'", (Throwable)e);
            }
        }
    }

    private EtherpadClientService getEtherpadClientService() throws ClientException {
        if (null == this.service) {
            this.service = (EtherpadClientService)Framework.getLocalService(EtherpadClientService.class);
        }
        if (null == this.service) {
            throw new ClientException("Failed to obtain the Etherpad client service");
        }
        return this.service;
    }
}

