/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.addons.toutapad.ecm.listeners;

import fr.toutatice.addons.toutapad.ecm.helpers.ToutapadDocumentHelper;
import fr.toutatice.addons.toutapad.ecm.services.EtherpadClientService;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.repository.Repository;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.EventContextImpl;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.ecm.platform.query.api.PageProviderService;
import org.nuxeo.runtime.api.Framework;

public class ToutapadEventListenerSynchronizePad
implements EventListener {
    private static final Log log = LogFactory.getLog(ToutapadEventListenerSynchronizePad.class);

    public void handleEvent(Event event) throws ClientException {
        if (event.getContext() instanceof EventContextImpl) {
            try {
                Collection repositories = ((RepositoryManager)Framework.getService(RepositoryManager.class)).getRepositories();
                for (Repository repository : repositories) {
                    ToutapadContentSynchronizationRunner runner = new ToutapadContentSynchronizationRunner(repository.getName());
                    runner.runUnrestricted();
                }
            }
            catch (Exception e) {
                log.error((Object)("Failed to synchronize the pad(s) content, error: " + e.getMessage()));
            }
        }
    }

    private class ToutapadContentSynchronizationRunner
    extends UnrestrictedSessionRunner {
        private EtherpadClientService service;

        public ToutapadContentSynchronizationRunner(String repository) {
            super(repository);
            this.service = null;
        }

        public void run() throws ClientException {
            List<DocumentModel> padsList = this.getActivePADs();
            if (null != padsList && 0 < padsList.size()) {
                for (DocumentModel pad : padsList) {
                    try {
                        String content = this.getEtherpadClientService().getPADContent(pad, "text");
                        ToutapadDocumentHelper.synchronizePad(this.session, pad, content);
                    }
                    catch (Exception e) {
                        log.error((Object)("Failed to synchronize the pad '" + pad.getTitle() + "' (id='" + pad.getId() + "'), error: " + e.getMessage()));
                    }
                }
            }
        }

        private EtherpadClientService getEtherpadClientService() throws ClientException {
            if (null == this.service) {
                this.service = (EtherpadClientService)Framework.getLocalService(EtherpadClientService.class);
                if (null == this.service) {
                    throw new ClientException("Failed to obtain the Etherpad client service");
                }
            }
            return this.service;
        }

        private List<DocumentModel> getActivePADs() {
            PageProviderService ppService = (PageProviderService)Framework.getService(PageProviderService.class);
            if (ppService == null) {
                throw new RuntimeException("Missing PageProvider service");
            }
            HashMap<String, Serializable> props = new HashMap<String, Serializable>();
            props.put("coreSession", (Serializable)this.session);
            props.put("useUnrestrictedSession", Boolean.TRUE);
            PageProvider pp = ppService.getPageProvider("GET_ACTIVE_PADS_FOR_SYNCHRONISATION", null, null, null, props, new Object[0]);
            if (pp == null) {
                throw new ClientException("Page provider not found: GET_ACTIVE_PADS_FOR_SYNCHRONISATION");
            }
            return pp.getCurrentPage();
        }
    }
}

