/*
 * Decompiled with CFR 0.152.
 */
package org.opentoutatice.elasticsearch.core.reindexing.docs.index;

import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.jsoup.helper.Validate;

public class IndexName
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -8717225631014747357L;
    private String namePart;
    private Long suffix;
    public static final String SEPARATOR = "__";

    public IndexName(String fullName) {
        String[] parts = StringUtils.split((String)fullName, (String)SEPARATOR);
        this.namePart = parts[0];
        if (parts.length == 2) {
            this.suffix = Long.valueOf(parts[1]);
        }
    }

    public IndexName(String name, Long suffix) {
        this.namePart = name;
        this.suffix = suffix;
    }

    public String value() {
        Validate.notNull((Object)this.namePart);
        return this.suffix != null ? this.namePart.concat(SEPARATOR).concat(this.suffix.toString()) : this.namePart;
    }

    public String toString() {
        return this.value();
    }

    public IndexName clone() {
        IndexName clone = null;
        try {
            clone = (IndexName)super.clone();
        }
        catch (CloneNotSupportedException e) {
            clone = new IndexName(this.namePart, this.suffix);
        }
        return clone;
    }

    public String getNamePart() {
        return this.namePart;
    }

    public Long getSuffix() {
        return this.suffix;
    }

    public boolean hasSuffix() {
        return this.suffix != null;
    }
}

