/*
 * Decompiled with CFR 0.152.
 */
package org.opentoutatice.elasticsearch.core.reindexing.docs.runner;

import java.text.DecimalFormat;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.runtime.api.Framework;
import org.opentoutatice.elasticsearch.OttcElasticSearchComponent;
import org.opentoutatice.elasticsearch.api.OttcElasticSearchIndexing;
import org.opentoutatice.elasticsearch.config.OttcElasticSearchIndexOrAliasConfig;
import org.opentoutatice.elasticsearch.core.reindexing.docs.es.state.EsState;
import org.opentoutatice.elasticsearch.core.reindexing.docs.exception.IndexException;
import org.opentoutatice.elasticsearch.core.reindexing.docs.index.IndexName;
import org.opentoutatice.elasticsearch.core.reindexing.docs.manager.IndexNAliasManager;
import org.opentoutatice.elasticsearch.core.reindexing.docs.manager.ReIndexingRunnerManager;
import org.opentoutatice.elasticsearch.core.reindexing.docs.manager.cfg.ReIndexingConfig;
import org.opentoutatice.elasticsearch.core.reindexing.docs.manager.exception.ReIndexingException;
import org.opentoutatice.elasticsearch.core.reindexing.docs.manager.exception.RecoveringReIndexingException;
import org.opentoutatice.elasticsearch.core.reindexing.docs.runner.ReIndexingErrorsHandler;
import org.opentoutatice.elasticsearch.core.reindexing.docs.runner.step.ReIndexingRunnerStep;
import org.opentoutatice.elasticsearch.core.reindexing.docs.runner.step.ReIndexingRunnerStepState;
import org.opentoutatice.elasticsearch.core.reindexing.docs.runner.step.ReIndexingRunnerStepStateStatus;
import org.opentoutatice.elasticsearch.core.service.OttcElasticSearchAdminImpl;

public class ReIndexingRunner {
    private static final Log log = LogFactory.getLog(ReIndexingRunner.class);
    private String workId;
    private ReIndexingConfig reIndexingConfig;
    private ReIndexingRunnerStep runnerStep;
    private OttcElasticSearchAdminImpl esAdmin;
    private OttcElasticSearchIndexing esIndexing;
    private EsState initialEsState;
    private static final String REINDEX_REPOSITORY_QUERY = "select ecm:uuid from Document";
    private static final DecimalFormat decimalFormat = new DecimalFormat("##.###");

    public ReIndexingRunner(String id, OttcElasticSearchIndexOrAliasConfig nxAliasCfg, OttcElasticSearchAdminImpl esAdmin, OttcElasticSearchIndexing esIndexing, EsState initialEsState) {
        this.workId = id;
        this.setReIndexingConfig(new ReIndexingConfig(nxAliasCfg));
        this.esAdmin(esAdmin).esIndexing(esIndexing);
        this.setInitialEsState(initialEsState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws ReIndexingException {
        String repository = this.getRepository();
        try {
            ReIndexingRunnerManager.get().setStartTimeFor(this.getWorkId());
            this.setRunnerStep(ReIndexingRunnerStep.initialization);
            OttcElasticSearchIndexOrAliasConfig nxAliasCfg = this.getNxAliasCfg(repository);
            IndexName newIndex = this.getNewIndex(repository);
            IndexName initialIndex = this.getInitialIndex(repository);
            OttcElasticSearchIndexOrAliasConfig newNxAliasCfg = null;
            try {
                this.setRunnerStep(ReIndexingRunnerStep.initialization.stepState(ReIndexingRunnerStepState.started.stepStatus(ReIndexingRunnerStepStateStatus.successfull)));
                this.checkInterrupt();
                newNxAliasCfg = this.createNewEsIndex(newIndex, nxAliasCfg);
                this.getEsAdmin().initIndex(newNxAliasCfg, false);
                this.createNSwitchOnTransientAliases(initialIndex, newIndex);
                if (Framework.isTestModeSet()) {
                    this.mayFireExceptionInTestMode(this.getRunnerStep());
                }
                this.setRunnerStep(ReIndexingRunnerStep.initialization.stepState(ReIndexingRunnerStepState.done.stepStatus(ReIndexingRunnerStepStateStatus.successfull)));
            }
            catch (Exception e) {
                this.manageReIndexingError(this.getWorkId(), nxAliasCfg.getAliasName(), initialIndex, newIndex, this.getRunnerStep(), this.getInitialEsState(), e);
            }
            try {
                this.setRunnerStep(ReIndexingRunnerStep.indexing.stepState(ReIndexingRunnerStepState.started.stepStatus(ReIndexingRunnerStepStateStatus.successfull)));
                this.checkInterrupt();
                this.reIndex(repository, newIndex);
                if (Framework.isTestModeSet()) {
                    this.mayFireExceptionInTestMode(this.getRunnerStep());
                }
                this.setRunnerStep(ReIndexingRunnerStep.indexing.stepState(ReIndexingRunnerStepState.done.stepStatus(ReIndexingRunnerStepStateStatus.successfull)));
            }
            catch (Exception e) {
                this.manageReIndexingError(this.getWorkId(), nxAliasCfg.getAliasName(), initialIndex, newIndex, this.getRunnerStep(), this.getInitialEsState(), e);
            }
            try {
                this.setRunnerStep(ReIndexingRunnerStep.switching.stepState(ReIndexingRunnerStepState.started.stepStatus(ReIndexingRunnerStepStateStatus.successfull)));
                this.checkInterrupt();
                this.updateEsAlias(nxAliasCfg.getAliasName(), initialIndex, newIndex);
                this.updateEsFormerAlias(nxAliasCfg.getAliasName(), initialIndex);
                this.deleteTransientAliases(initialIndex, newIndex);
                ReIndexingRunnerManager.get().setNewIndexFor(this.getWorkId(), newIndex);
                if (Framework.isTestModeSet()) {
                    this.mayFireExceptionInTestMode(this.getRunnerStep());
                }
                this.checkInterrupt();
                this.setRunnerStep(ReIndexingRunnerStep.switching.stepState(ReIndexingRunnerStepState.done.stepStatus(ReIndexingRunnerStepStateStatus.successfull)));
            }
            catch (Exception e) {
                this.manageReIndexingError(this.getWorkId(), nxAliasCfg.getAliasName(), initialIndex, newIndex, this.getRunnerStep(), this.getInitialEsState(), e);
            }
        }
        finally {
            ReIndexingRunnerManager.get().setEndTimeFor(this.getWorkId());
        }
    }

    private void manageReIndexingError(String workId, String currentAlias, IndexName initialIndex, IndexName newIndex, ReIndexingRunnerStep step, EsState initialEsState, Exception e) throws ReIndexingException {
        ReIndexingException reIndexingException = new ReIndexingException(String.format("[Re-indexing process INTERRUPTED during [%s] step]: ", step.name()), e);
        step.getStepState().stepStatus(ReIndexingRunnerStepStateStatus.inError.error(reIndexingException));
        try {
            ReIndexingErrorsHandler.get().restoreInitialEsState(workId, step, initialEsState, initialIndex, newIndex, currentAlias);
        }
        catch (RecoveringReIndexingException re) {
            Throwable cause = re.getCause();
            cause.initCause(reIndexingException);
            throw re;
        }
        throw reIndexingException;
    }

    private void checkInterrupt() throws InterruptedException {
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException(String.format("Zero Down Time work [%s] INTERUPTED.", this.getWorkId()));
        }
    }

    protected OttcElasticSearchIndexOrAliasConfig createNewEsIndex(IndexName newIndexName, OttcElasticSearchIndexOrAliasConfig nxIndexNAliasCfg) throws ReIndexingException {
        try {
            return IndexNAliasManager.get().createNewIndex(newIndexName, nxIndexNAliasCfg);
        }
        catch (InterruptedException | ExecutionException | IndexException e) {
            throw new ReIndexingException(e);
        }
    }

    protected void createNSwitchOnTransientAliases(IndexName initialIndex, IndexName newIndex) throws ReIndexingException {
        IndexNAliasManager.get().createTransientAliases(initialIndex, newIndex);
    }

    protected void reIndex(String repository, IndexName newIndex) throws ReIndexingException {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"About to launch Re-indexing...");
            }
            ((OttcElasticSearchComponent)this.getEsIndexing()).runReindexingWorker(repository, REINDEX_REPOSITORY_QUERY, true);
            if (log.isInfoEnabled()) {
                log.info((Object)"Re-indexing launched.");
            }
            this.setRunnerStep(ReIndexingRunnerStep.indexing.stepState(ReIndexingRunnerStepState.inProgress.stepStatus(ReIndexingRunnerStepStateStatus.successfull)));
            this.waitReIndexing();
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Refreshing new index [%s]", newIndex.toString()));
            }
            this.getEsAdmin().refreshRepositoryIndex(repository);
        }
        catch (InterruptedException | RuntimeException e) {
            throw new ReIndexingException(e);
        }
    }

    protected void waitReIndexing() throws InterruptedException {
        long timeOut = 100L;
        long loopWaitTime = Long.valueOf(Framework.getProperty((String)"ottc.reindexing.check.loop.period", (String)"30"));
        long startTime = System.currentTimeMillis();
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Starting waiting for re-indexing every [%s %s]", String.valueOf(loopWaitTime), StringUtils.lowerCase((String)String.valueOf(TimeUnit.SECONDS.toString()))));
        }
        WorkManager workManager = (WorkManager)Framework.getService(WorkManager.class);
        if (log.isInfoEnabled()) {
            log.info((Object)"...");
        }
        boolean awaitCompletion = false;
        do {
            Thread.sleep(loopWaitTime * 1000L);
            if (!log.isTraceEnabled()) continue;
            log.trace((Object)String.format("Await completed: [%s]", String.valueOf(awaitCompletion)));
        } while (!(awaitCompletion = workManager.awaitCompletion("zeroDownTimeEsReIndexing", 100L, TimeUnit.MILLISECONDS)));
        Validate.isTrue((boolean)awaitCompletion);
        this.setRunnerStep(ReIndexingRunnerStep.indexing.stepState(ReIndexingRunnerStepState.done.stepStatus(ReIndexingRunnerStepStateStatus.successfull)));
        if (log.isInfoEnabled()) {
            float duration = (float)(System.currentTimeMillis() - startTime) / 1000.0f;
            log.info((Object)String.format("End waiting: re-indexing done in [%s] s", decimalFormat.format(duration)));
        }
    }

    private void updateEsAlias(String aliasName, IndexName initialIndex, IndexName newIndex) throws ReIndexingException {
        IndexNAliasManager.get().updateEsAlias(aliasName, initialIndex, newIndex);
    }

    private void updateEsFormerAlias(String aliasName, IndexName initialIndex) throws ReIndexingException {
        IndexNAliasManager.get().updateEsFormerAlias(aliasName, initialIndex);
    }

    private void deleteTransientAliases(IndexName initialIndex, IndexName newIndex) throws ReIndexingException {
        IndexNAliasManager.get().deleteTransientAliases(initialIndex, newIndex);
    }

    private OttcElasticSearchIndexOrAliasConfig getNxAliasCfg(String repository) {
        return this.getReIndexingConfig().getNxAliasCfg();
    }

    private IndexName getNewIndex(String repository) {
        return this.getReIndexingConfig().getNewIndex();
    }

    private IndexName getInitialIndex(String repository) {
        return this.getReIndexingConfig().getInitialIndex();
    }

    private String getRepository() {
        Validate.notNull((Object)this.getReIndexingConfig());
        Validate.notNull((Object)this.getReIndexingConfig().getNxAliasCfg());
        return this.getReIndexingConfig().getNxAliasCfg().getRepositoryName();
    }

    public String getWorkId() {
        return this.workId;
    }

    public void setWorkId(String workId) {
        this.workId = workId;
    }

    public ReIndexingConfig getReIndexingConfig() {
        return this.reIndexingConfig;
    }

    private void setReIndexingConfig(ReIndexingConfig reIndexingCfg) {
        this.reIndexingConfig = reIndexingCfg;
    }

    public ReIndexingRunnerStep getRunnerStep() {
        return this.runnerStep;
    }

    private void setRunnerStep(ReIndexingRunnerStep runnerStep) {
        this.runnerStep = runnerStep;
        ReIndexingRunnerManager.get().setRunnerStepFor(this.getWorkId(), runnerStep);
    }

    public OttcElasticSearchAdminImpl getEsAdmin() {
        return this.esAdmin;
    }

    public ReIndexingRunner esAdmin(OttcElasticSearchAdminImpl esAdmin) {
        Validate.notNull((Object)esAdmin);
        this.esAdmin = esAdmin;
        return this;
    }

    public OttcElasticSearchIndexing getEsIndexing() {
        return this.esIndexing;
    }

    public ReIndexingRunner esIndexing(OttcElasticSearchIndexing esIndexing) {
        Validate.notNull((Object)esIndexing);
        this.esIndexing = esIndexing;
        return this;
    }

    public EsState getInitialEsState() {
        return this.initialEsState;
    }

    private void setInitialEsState(EsState initialEsState) {
        this.initialEsState = initialEsState;
    }

    private void mayFireExceptionInTestMode(ReIndexingRunnerStep step) throws Exception {
        if (StringUtils.equals((String)step.name(), (String)Framework.getProperty((String)"ottc.reindexing.test.mode.fire.errors.step"))) {
            throw new Exception(String.format("[ERROR TEST] during: %s", step.name()));
        }
    }
}

