/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.web.publication.tree;

import fr.toutatice.ecm.platform.core.query.helper.ToutaticeEsQueryHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.tree.DefaultDocumentTreeSorter;
import org.nuxeo.ecm.platform.publisher.api.PublicationNode;
import org.nuxeo.ecm.platform.publisher.api.PublishedDocumentFactory;
import org.nuxeo.ecm.platform.publisher.impl.core.CoreFolderPublicationNode;

public class ToutaticeCoreFolderPublicationNode
extends CoreFolderPublicationNode {
    private static final long serialVersionUID = 8111887640605954307L;
    private static final Log log = LogFactory.getLog(ToutaticeCoreFolderPublicationNode.class);

    public ToutaticeCoreFolderPublicationNode(DocumentModel doc, String treeConfigName, String sid, PublicationNode parent, PublishedDocumentFactory factory) throws ClientException {
        super(doc, treeConfigName, sid, parent, factory);
    }

    public ToutaticeCoreFolderPublicationNode(DocumentModel document, String configName, String sessionId, PublishedDocumentFactory factory) throws ClientException {
        super(document, configName, sessionId, factory);
    }

    protected String buildChildrenWhereClause(boolean queryDocuments) {
        StringBuffer clause = new StringBuffer();
        clause.append(String.format(" ecm:parentId = '%s' AND ecm:currentLifeCycleState != '%s'", this.folder.getId(), "deleted"));
        clause.append(String.format(" AND ecm:mixinType IN ('%s' , '%s' ) ", "MasterPublishSpace", "PublishSpace"));
        clause.append(String.format(" AND ecm:mixinType NOT IN ('%s')", "HiddenInNavigation"));
        clause.append(" AND (ecm:isVersion = 0 AND ecm:isProxy = 0) ");
        return clause.toString();
    }

    public List<PublicationNode> getChildrenNodes() throws ClientException {
        DocumentModelList children = this.getSortedChildren(false);
        ArrayList<PublicationNode> childrenNodes = new ArrayList<PublicationNode>();
        for (DocumentModel child : children) {
            childrenNodes.add((PublicationNode)new ToutaticeCoreFolderPublicationNode(child, this.treeConfigName, this.sid, (PublicationNode)this, this.factory));
        }
        return childrenNodes;
    }

    protected DocumentModelList getSortedChildren(boolean queryDocuments) throws ClientException {
        String whereClause = this.buildChildrenWhereClause(queryDocuments);
        DocumentModelList children = ToutaticeEsQueryHelper.query((CoreSession)this.getCoreSession(), (String)("SELECT * FROM Document WHERE " + whereClause));
        if (!this.folder.hasFacet("Orderable")) {
            DefaultDocumentTreeSorter sorter = new DefaultDocumentTreeSorter();
            sorter.setSortPropertyPath("dc:title");
            Collections.sort(children, sorter);
        }
        return children;
    }
}

