/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.web.workflows;

import fr.toutatice.ecm.platform.core.helper.ToutaticeWorkflowHelper;
import java.util.Iterator;
import java.util.List;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.task.Task;
import org.nuxeo.ecm.platform.task.web.TaskActionsBean;
import org.nuxeo.ecm.platform.ui.web.invalidations.AutomaticDocumentBasedInvalidation;

@Name(value="taskActions")
@Scope(value=ScopeType.CONVERSATION)
@AutomaticDocumentBasedInvalidation
@Install(precedence=31)
public class ToutaticeTaskActionsBean
extends TaskActionsBean {
    private static final long serialVersionUID = 3730629195809387779L;

    public boolean hasNuxeoPublishTaskPending() throws ClientException {
        boolean hasNuxeoPublicationTask = false;
        this.tasks = null;
        List currentDocumentTasks = this.getCurrentDocumentTasks();
        if (currentDocumentTasks != null && !currentDocumentTasks.isEmpty()) {
            Iterator iterator = currentDocumentTasks.iterator();
            while (iterator.hasNext() && !hasNuxeoPublicationTask) {
                Task task = (Task)iterator.next();
                if (!"org.nuxeo.ecm.platform.publisher.task.CoreProxyWithWorkflowFactory".equals(task.getName())) continue;
                hasNuxeoPublicationTask = task.isOpened();
            }
        }
        return hasNuxeoPublicationTask;
    }

    public boolean isValidateOnlineActionAuthorized() throws ClientException {
        return this.isTaskActionAuthorized("validate-online");
    }

    protected boolean isTaskActionAuthorized(String taskName) throws ClientException {
        boolean isAuthorized = false;
        this.tasks = null;
        List currentDocumentTasks = this.getCurrentDocumentTasks();
        if (currentDocumentTasks != null) {
            Iterator iterator = currentDocumentTasks.iterator();
            while (iterator.hasNext() && !isAuthorized) {
                Task task = (Task)iterator.next();
                if (!task.isOpened().booleanValue() || !taskName.equals(task.getName())) continue;
                isAuthorized = true;
            }
        }
        return isAuthorized;
    }

    public String getValidateOnlineTaskName() {
        return "validate-online";
    }

    public Task getValidateOnlineTask() throws ClientException {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        return ToutaticeWorkflowHelper.getTaskByName((String)"validate-online", (CoreSession)this.documentManager, (DocumentModel)currentDocument);
    }

    public boolean isValidateOnlineTask(Task task) throws ClientException {
        if (task != null) {
            return "validate-online".equals(task.getName());
        }
        return false;
    }

    public Task getTask(String nameTask) throws ClientException {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        return ToutaticeWorkflowHelper.getTaskByName((String)nameTask, (CoreSession)this.documentManager, (DocumentModel)currentDocument);
    }
}

