/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.procedures.es.customizer.writer.helper;

import com.ibm.icu.text.SimpleDateFormat;
import java.io.IOException;
import java.text.ParseException;
import java.util.Collection;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.BaseJsonNode;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.impl.ListProperty;
import org.nuxeo.ecm.core.schema.utils.DateParser;

public class DenormalizationJsonESWriterHelper {
    public static Pattern COMPLEX_PROPERTY_PATTERN = Pattern.compile("^[\\[\\{](.+)[\\]\\}]$");
    public static Pattern DATE_PATTERN = Pattern.compile("^([0-2][0-9]||3[0-1])/(0[0-9]||1[0-2])/([0-9][0-9])?[0-9][0-9]$");
    public static final SimpleDateFormat format = new SimpleDateFormat("dd/MM/yyyy");

    private DenormalizationJsonESWriterHelper() {
    }

    public static JsonGenerator mapKeyValue(JsonGenerator jg, DocumentModel doc, String listPropXPath, String entryKey, String entryValue) throws JsonGenerationException, IOException {
        ListProperty valuesProp = (ListProperty)doc.getProperty(listPropXPath);
        if (valuesProp != null && !valuesProp.isEmpty()) {
            jg.writeFieldName(listPropXPath);
            jg.writeStartObject();
            for (Property valueProp : valuesProp) {
                String name = (String)((Object)valueProp.get(entryKey).getValue());
                String value = (String)((Object)valueProp.get(entryValue).getValue());
                if (!StringUtils.isNotEmpty((String)name) || !StringUtils.isNotEmpty((String)value)) continue;
                jg.writeStringField(name, value);
            }
            jg.writeEndObject();
        }
        return jg;
    }

    public static JsonGenerator mapKeyValueAsJson(JsonGenerator jg, String customProperty, DocumentModel doc, String listPropXPath, String entryKey, String entryValue) throws JsonGenerationException, IOException {
        ListProperty valuesProp = (ListProperty)doc.getProperty(listPropXPath);
        if (CollectionUtils.isNotEmpty((Collection)valuesProp)) {
            jg.writeFieldName(customProperty);
            jg.writeStartObject();
            for (Property valueProp : valuesProp) {
                String name = (String)((Object)valueProp.get(entryKey).getValue());
                String value = (String)((Object)valueProp.get(entryValue).getValue());
                if (!StringUtils.isNotEmpty((String)name) || !StringUtils.isNotEmpty((String)value)) continue;
                Matcher matcher = COMPLEX_PROPERTY_PATTERN.matcher(value);
                if (matcher.matches()) {
                    ObjectMapper mapper = new ObjectMapper();
                    BaseJsonNode jsonNode = (BaseJsonNode)mapper.readValue(value, BaseJsonNode.class);
                    jg.writeFieldName(name);
                    jsonNode.serialize(jg, null);
                    continue;
                }
                Matcher dateMatcher = DATE_PATTERN.matcher(value);
                if (dateMatcher.matches()) {
                    String initialValue = value;
                    try {
                        value = DateParser.formatW3CDateTime((Date)format.parse(value));
                    }
                    catch (ParseException e) {
                        value = initialValue;
                    }
                }
                jg.writeStringField(name, value);
            }
            jg.writeEndObject();
        }
        return jg;
    }
}

