/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.procedures.instances.operations;

import fr.toutatice.ecm.platform.core.helper.ToutaticeDocumentHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.core.util.Properties;
import org.nuxeo.ecm.automation.core.util.StringList;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.NuxeoGroup;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.platform.task.Task;
import org.nuxeo.ecm.platform.task.TaskService;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.runtime.api.Framework;

public abstract class AbstractProcedureUnrestrictedSessionRunner
extends UnrestrictedSessionRunner {
    private final Properties properties;
    private final TaskService taskService;
    private final UserManager userManager;

    protected AbstractProcedureUnrestrictedSessionRunner(CoreSession session, Properties properties) {
        super(session);
        this.properties = properties;
        this.taskService = (TaskService)Framework.getService(TaskService.class);
        this.userManager = (UserManager)Framework.getService(UserManager.class);
    }

    protected DocumentModel getModel() {
        String webId = (String)this.properties.get((Object)"pi:procedureModelWebId");
        StringBuilder query = new StringBuilder();
        query.append("SELECT * FROM Document ");
        query.append("WHERE ttc:webid = '").append(webId).append("' ");
        DocumentModelList result = this.session.query(query.toString(), 1);
        if (result.isEmpty()) {
            StringBuilder message = new StringBuilder();
            message.append("Model '").append(webId).append("' not found.");
            throw new ClientException(message.toString());
        }
        DocumentModel model = (DocumentModel)result.get(0);
        return model;
    }

    protected void createTask(DocumentModel model, DocumentModel procedureInstance, String processId, String title, StringList actors, StringList additionalAuthorizations) {
        DocumentModel task;
        List taskInstances = this.taskService.getAllTaskInstances(processId, this.session);
        if (taskInstances.size() == 1) {
            Task instance = (Task)taskInstances.get(0);
            task = instance.getDocument();
        } else {
            task = null;
        }
        if (task != null) {
            task.setPropertyValue("nt:name", (Serializable)((Object)title));
            task.setPropertyValue("dc:title", (Serializable)((Object)model.getTitle()));
            this.setTaskVariables(model, procedureInstance, task);
            this.setActors(task, actors);
            this.setAcl(task, actors, additionalAuthorizations);
            ToutaticeDocumentHelper.saveDocumentSilently((CoreSession)this.session, (DocumentModel)task, (boolean)true);
        }
    }

    private void setTaskVariables(DocumentModel model, DocumentModel procedureInstance, DocumentModel task) {
        List<Map<String, Serializable>> stepVariables = this.getStepVariables(model, procedureInstance);
        List<Map<String, Serializable>> taskVariables = this.getTaskVariables(task);
        ArrayList<Map<String, Serializable>> variables = new ArrayList<Map<String, Serializable>>(stepVariables.size() + taskVariables.size());
        variables.addAll(stepVariables);
        variables.addAll(taskVariables);
        task.setPropertyValue("nt:task_variables", (Serializable)variables);
    }

    private List<Map<String, Serializable>> getStepVariables(DocumentModel model, DocumentModel procedureInstance) {
        String webId = (String)procedureInstance.getProperty("ttc:webid").getValue(String.class);
        List steps = (List)model.getProperty("pcd:steps").getValue(List.class);
        ArrayList stepVariables = null;
        if (CollectionUtils.isNotEmpty((Collection)steps)) {
            for (Object step : steps) {
                Map sourceMap = (Map)step;
                HashMap<String, Object> targetMap = new HashMap<String, Object>(sourceMap.size());
                for (Map.Entry entry : sourceMap.entrySet()) {
                    String key = (String)entry.getKey();
                    Serializable value = (Serializable)entry.getValue();
                    targetMap.put(key, value);
                }
                String reference = (String)targetMap.get("reference");
                if (!StringUtils.equals((String)reference, (String)((String)this.properties.get((Object)"pi:currentStep")))) continue;
                targetMap.put("documentWebId", webId);
                targetMap.put("documentPath", procedureInstance.getPathAsString());
                String[] names = new String[]{"notifiable", "notifEmail", "acquitable", "closable", "actionIdClosable", "actionIdYes", "actionIdNo", "stringMsg", "documentWebId", "documentPath"};
                stepVariables = new ArrayList(names.length);
                for (String key : names) {
                    Object object = targetMap.get(key);
                    String value = object instanceof String ? (String)object : (object instanceof Boolean ? BooleanUtils.toStringTrueFalse((Boolean)((Boolean)object)) : String.valueOf(object));
                    HashMap<String, String> stepVariable = new HashMap<String, String>(2);
                    stepVariable.put("key", key);
                    stepVariable.put("value", value);
                    stepVariables.add(stepVariable);
                }
            }
        }
        if (stepVariables == null) {
            stepVariables = new ArrayList(0);
        }
        return stepVariables;
    }

    private List<Map<String, Serializable>> getTaskVariables(DocumentModel task) {
        ArrayList<Map<String, Serializable>> taskVariables;
        List variables = (List)task.getProperty("nt:task_variables").getValue(List.class);
        if (CollectionUtils.isEmpty((Collection)variables)) {
            taskVariables = new ArrayList<Map<String, Serializable>>(0);
        } else {
            taskVariables = new ArrayList(variables.size());
            for (Object variable : variables) {
                Map sourceMap = (Map)variable;
                HashMap<String, Serializable> targetMap = new HashMap<String, Serializable>(sourceMap.size());
                for (Map.Entry entry : sourceMap.entrySet()) {
                    String key = (String)entry.getKey();
                    Serializable value = (Serializable)entry.getValue();
                    targetMap.put(key, value);
                }
                taskVariables.add(targetMap);
            }
        }
        return taskVariables;
    }

    private void setActors(DocumentModel task, StringList actorsP) {
        if (CollectionUtils.isNotEmpty((Collection)actorsP)) {
            ArrayList<String> actors = new ArrayList<String>();
            for (String user : actorsP) {
                NuxeoGroup group = this.userManager.getGroup(user);
                String prefix = group == null ? "user:" : "group:";
                actors.add(prefix + user);
            }
            task.setPropertyValue("nt:actors", (Serializable)actors);
        }
    }

    private void setAcl(DocumentModel task, StringList actors, StringList additionalAuthorizations) {
        ACE ace;
        ACP acp = task.getACP();
        ACL acl = acp.getOrCreateACL("local");
        if (CollectionUtils.isNotEmpty((Collection)actors)) {
            for (String user : actors) {
                ace = new ACE(user, "Everything", true);
                acl.add((Object)ace);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)additionalAuthorizations)) {
            for (String additionalAuthorization : additionalAuthorizations) {
                ace = new ACE(additionalAuthorization, "Everything", true);
                acl.add((Object)ace);
            }
        }
        acp.addACL(acl);
        task.setACP(acp, true);
    }
}

