/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.procedures.instances.operations;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.nuxeo.ecm.automation.core.util.DocumentHelper;
import org.nuxeo.ecm.automation.core.util.Properties;
import org.nuxeo.ecm.automation.core.util.StringList;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.platform.routing.api.DocumentRoutingService;
import org.nuxeo.ecm.platform.task.Task;
import org.nuxeo.ecm.platform.task.TaskService;
import org.nuxeo.runtime.api.Framework;
import org.osivia.procedures.instances.operations.AbstractProcedureUnrestrictedSessionRunner;

public class UpdateProcedureUnrestrictedSessionRunner
extends AbstractProcedureUnrestrictedSessionRunner {
    private DocumentModel procedureInstance;
    private final String title;
    private final Properties properties;
    private final StringList actors;
    private final StringList additionalAuthorizations;
    private final DocumentRoutingService documentRoutingService;
    private final TaskService taskService;

    public UpdateProcedureUnrestrictedSessionRunner(CoreSession session, DocumentModel procedureInstance, String title, Properties properties, StringList actors, StringList additionalAuthorizations) {
        super(session, properties);
        this.procedureInstance = procedureInstance;
        this.title = title;
        this.properties = properties;
        this.actors = actors;
        this.additionalAuthorizations = additionalAuthorizations;
        this.documentRoutingService = (DocumentRoutingService)Framework.getService(DocumentRoutingService.class);
        this.taskService = (TaskService)Framework.getService(TaskService.class);
    }

    public void run() throws ClientException {
        DocumentModel model = this.getModel();
        try {
            DocumentHelper.setProperties((CoreSession)this.session, (DocumentModel)this.procedureInstance, (Properties)this.properties);
        }
        catch (IOException e) {
            throw new ClientException((Throwable)e);
        }
        this.procedureInstance = this.session.saveDocument(this.procedureInstance);
        NuxeoPrincipal actor = null;
        List previousTasks = this.taskService.getTaskInstances(this.procedureInstance, actor, this.session);
        if (previousTasks.size() != 1) {
            throw new ClientException("Task not found.");
        }
        Task previousTask = (Task)previousTasks.get(0);
        String processId = previousTask.getProcessId();
        HashMap data = new HashMap(0);
        this.documentRoutingService.endTask(this.session, previousTask, data, "");
        this.createTask(model, this.procedureInstance, processId, this.title, this.actors, this.additionalAuthorizations);
        this.procedureInstance.detach(true);
    }

    public DocumentModel getProcedureInstance() {
        return this.procedureInstance;
    }
}

