/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.procedures.record.security.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.index.query.AndFilterBuilder;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.FilterBuilders;
import org.elasticsearch.index.query.OrFilterBuilder;
import org.nuxeo.ecm.core.api.CoreSession;
import org.osivia.procedures.record.security.rules.SecurityRulesBuilder;
import org.osivia.procedures.record.security.rules.model.SecurityRelation;
import org.osivia.procedures.record.security.rules.model.SecurityRelationType;
import org.osivia.procedures.record.security.rules.model.SecurityRelations;

public class SecurityClauseBuilder {
    private static final Log log = LogFactory.getLog(SecurityClauseBuilder.class);
    private static SecurityClauseBuilder instance;
    private static SecurityRulesBuilder rulesManager;

    private SecurityClauseBuilder() {
    }

    public static synchronized SecurityClauseBuilder getInstance() {
        if (instance == null) {
            instance = new SecurityClauseBuilder();
        }
        return instance;
    }

    public static SecurityClauseBuilder getSecurityRulesManager() {
        if (rulesManager == null) {
            rulesManager = SecurityRulesBuilder.getInstance();
        }
        return instance;
    }

    public FilterBuilder getFilter(CoreSession session) {
        long begin = System.currentTimeMillis();
        OrFilterBuilder filterBuilder = null;
        SecurityRelations rules = SecurityRulesBuilder.getInstance().buildSecurityRelations(session, session.getPrincipal());
        List<FilterBuilder> filters = this.build(session, rules);
        if (filters.size() > 0) {
            filterBuilder = FilterBuilders.orFilter((FilterBuilder[])filters.toArray(new FilterBuilder[0]));
        }
        if (log.isDebugEnabled()) {
            long end = System.currentTimeMillis();
            log.debug((Object)("[#getFilter] " + String.valueOf(end - begin) + " ms"));
        }
        return filterBuilder;
    }

    public List<FilterBuilder> build(CoreSession session, SecurityRelations rules) {
        long begin = System.currentTimeMillis();
        LinkedList<FilterBuilder> filters = new LinkedList<FilterBuilder>();
        if (rules != null) {
            block4: for (SecurityRelation relation : rules) {
                switch (relation.getType()) {
                    case NtoOne: {
                        ArrayList ids = (ArrayList)relation.getRecordsIds();
                        if (!CollectionUtils.isNotEmpty((Collection)ids)) break;
                        for (String id : ids) {
                            AndFilterBuilder oneToOneFilter = FilterBuilders.andFilter((FilterBuilder[])new FilterBuilder[]{FilterBuilders.termFilter((String)"rcd:type", (String)relation.getRecordType()), FilterBuilders.termFilter((String)("rcd:data." + this.adapt(SecurityRelationType.NtoOne, relation.getRelationKey())), (String)id)});
                            filters.add((FilterBuilder)oneToOneFilter);
                        }
                        continue block4;
                    }
                    case NtoN: {
                        if (!CollectionUtils.isNotEmpty(relation.getRecordsIds())) break;
                        AndFilterBuilder oneToNFilter = FilterBuilders.andFilter((FilterBuilder[])new FilterBuilder[]{FilterBuilders.termFilter((String)"rcd:type", (String)relation.getRecordType()), FilterBuilders.inFilter((String)this.adapt(SecurityRelationType.NtoN, relation.getRelationKey()), (String[])this.getIds(relation.getRecordsIds()))});
                        filters.add((FilterBuilder)oneToNFilter);
                        break;
                    }
                }
            }
        }
        if (log.isDebugEnabled()) {
            long end = System.currentTimeMillis();
            log.debug((Object)("[#build] " + String.valueOf(end - begin) + " ms"));
        }
        return filters;
    }

    protected String[] getIds(Object value) {
        if (value instanceof ArrayList) {
            ArrayList values = (ArrayList)value;
            return values.toArray(new String[0]);
        }
        return null;
    }

    protected String adapt(SecurityRelationType relationType, String relationKey) {
        String key = relationKey;
        switch (relationType) {
            case NtoOne: {
                key = key + ".ttc:webid";
                break;
            }
            case NtoN: {
                key = "ttc:webid";
                break;
            }
        }
        return key;
    }
}

