/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.procedures.record.security.rules;

import fr.toutatice.ecm.platform.core.query.helper.ToutaticeEsQueryHelper;
import java.security.Principal;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.osivia.procedures.record.security.rules.RecordsRelationsResolver;
import org.osivia.procedures.record.security.rules.SecurityEntitiesResolver;
import org.osivia.procedures.record.security.rules.UnrestrictedSecurityRulesBuilder;
import org.osivia.procedures.record.security.rules.helper.RecordModelHelper;
import org.osivia.procedures.record.security.rules.model.SecurityRelation;
import org.osivia.procedures.record.security.rules.model.SecurityRelations;
import org.osivia.procedures.record.security.rules.model.relation.RecordsRelation;
import org.osivia.procedures.record.security.rules.model.type.Entity;

public class SecurityRulesBuilder {
    private static final Log log = LogFactory.getLog(SecurityRulesBuilder.class);
    private static SecurityRulesBuilder instance;
    private Map<String, SecurityRelations> rulesByUser = new ConcurrentHashMap<String, SecurityRelations>(0);
    private RecordsRelationsResolver resolver;

    private SecurityRulesBuilder() {
    }

    public static synchronized SecurityRulesBuilder getInstance() {
        if (instance == null) {
            instance = new SecurityRulesBuilder();
        }
        return instance;
    }

    public RecordsRelationsResolver getRecordsRelationsResolver() {
        if (this.resolver == null) {
            this.resolver = RecordsRelationsResolver.getInstance();
        }
        return this.resolver;
    }

    public SecurityRelations buildSecurityRelations(CoreSession session, Principal currentPrincipal) {
        UnrestrictedSecurityRulesBuilder builder = new UnrestrictedSecurityRulesBuilder(session, currentPrincipal);
        builder.runUnrestricted();
        return builder.getSecurityRelations();
    }

    public SecurityRelations build(CoreSession session, Principal currentPrincipal) {
        SecurityRelations rules = null;
        if (this.rulesByUser.containsKey(currentPrincipal.getName())) {
            rules = this.rulesByUser.get(currentPrincipal.getName());
        } else {
            rules = new SecurityRelations(0);
            Map<String, Entity> securityEntities = SecurityEntitiesResolver.getInstance().getSecurityEntitiesOf(session, currentPrincipal);
            if (securityEntities != null && securityEntities.size() > 0) {
                DocumentModelList models = ToutaticeEsQueryHelper.query((CoreSession)session, (String)RecordModelHelper.RECORD_MODELS_QUERY);
                long begin = System.currentTimeMillis();
                Map<String, Entity> treatedEntities = securityEntities;
                HashSet<RecordsRelation> treatedRelations = new HashSet<RecordsRelation>(0);
                rules = this.buildSecurity(session, rules, securityEntities, models, treatedEntities, treatedRelations);
                this.rulesByUser.put(currentPrincipal.getName(), rules);
                if (log.isDebugEnabled()) {
                    long end = System.currentTimeMillis();
                    log.debug((Object)("[#resolveLinkedEntites] " + String.valueOf(end - begin) + " ms"));
                }
            }
        }
        return rules;
    }

    public synchronized void invalidateRulesOf(String userName) {
        this.rulesByUser.remove(userName);
    }

    public SecurityRelations buildSecurity(CoreSession session, SecurityRelations securityRelations, Map<String, Entity> entities, DocumentModelList models, Map<String, Entity> treatedEntities, Set<RecordsRelation> treteadRelations) {
        for (Entity entity : entities.values()) {
            Map<String, Entity> nextEntities;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Treating: " + entity.getType()));
            }
            SecurityRelations inComingRelations = this.getRecordsRelationsResolver().getInComingRelations(session, models, entity, treatedEntities, treteadRelations);
            this.store(securityRelations, inComingRelations);
            if (log.isDebugEnabled()) {
                log.debug((Object)"* in:");
                for (Object sr : inComingRelations) {
                    log.debug((Object)(" - " + ((SecurityRelation)sr).getRecordType()));
                }
            }
            SecurityRelations outComingRelations = this.getRecordsRelationsResolver().getOutComingRelations(session, models, entity, treatedEntities, treteadRelations);
            this.store(securityRelations, outComingRelations);
            if (log.isDebugEnabled()) {
                Object sr;
                log.debug((Object)"* out:");
                sr = outComingRelations.iterator();
                while (sr.hasNext()) {
                    SecurityRelation sr2 = (SecurityRelation)sr.next();
                    log.debug((Object)(" - " + sr2.getRecordType()));
                }
            }
            if (!MapUtils.isNotEmpty(nextEntities = this.getNextEntities(inComingRelations, outComingRelations))) continue;
            this.buildSecurity(session, securityRelations, nextEntities, models, treatedEntities, treteadRelations);
        }
        return securityRelations;
    }

    private void store(SecurityRelations securityRelations, SecurityRelations relations) {
        if (relations != null) {
            for (SecurityRelation sr : relations) {
                if (securityRelations.contains(sr)) continue;
                securityRelations.add(sr);
            }
        }
    }

    private synchronized Map<String, Entity> getNextEntities(SecurityRelations inComingRelations, SecurityRelations outComingRelations) {
        Entity entity;
        ConcurrentHashMap<String, Entity> nextEntities = new ConcurrentHashMap<String, Entity>(0);
        for (SecurityRelation inSr : inComingRelations) {
            entity = inSr.getEntity();
            nextEntities.put(entity.getType(), entity);
        }
        for (SecurityRelation outSr : outComingRelations) {
            entity = outSr.getEntity();
            nextEntities.put(entity.getType(), entity);
        }
        return nextEntities;
    }
}

